/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.bayeux.oumuamua.server.api.json;

import java.util.Collection;
import org.smallmind.bayeux.oumuamua.server.api.json.Value;
import org.smallmind.bayeux.oumuamua.server.api.json.ValueType;

public interface ArrayValue<V extends Value<V>>
extends Value<V> {
    @Override
    default public ValueType getType() {
        return ValueType.ARRAY;
    }

    default public ArrayValue<V> add(boolean bool) {
        return this.add(this.getFactory().booleanValue(bool));
    }

    default public ArrayValue<V> set(int index, boolean bool) {
        return this.set(index, this.getFactory().booleanValue(bool));
    }

    default public ArrayValue<V> insert(int index, boolean bool) {
        return this.insert(index, this.getFactory().booleanValue(bool));
    }

    default public ArrayValue<V> add(int i) {
        return this.add(this.getFactory().numberValue(i));
    }

    default public ArrayValue<V> set(int index, int i) {
        return this.set(index, this.getFactory().numberValue(i));
    }

    default public ArrayValue<V> insert(int index, int i) {
        return this.insert(index, this.getFactory().numberValue(i));
    }

    default public ArrayValue<V> add(long l) {
        return this.add(this.getFactory().numberValue(l));
    }

    default public ArrayValue<V> set(int index, long l) {
        return this.set(index, this.getFactory().numberValue(l));
    }

    default public ArrayValue<V> insert(int index, long l) {
        return this.insert(index, this.getFactory().numberValue(l));
    }

    default public ArrayValue<V> add(double d) {
        return this.add(this.getFactory().numberValue(d));
    }

    default public ArrayValue<V> set(int index, double d) {
        return this.set(index, this.getFactory().numberValue(d));
    }

    default public ArrayValue<V> insert(int index, double d) {
        return this.insert(index, this.getFactory().numberValue(d));
    }

    default public ArrayValue<V> add(String text) {
        return this.add(this.getFactory().textValue(text));
    }

    default public ArrayValue<V> set(int index, String text) {
        return this.set(index, this.getFactory().textValue(text));
    }

    default public ArrayValue<V> insert(int index, String text) {
        return this.insert(index, this.getFactory().textValue(text));
    }

    public int size();

    public boolean isEmpty();

    public Value<V> get(int var1);

    public <U extends Value<V>> ArrayValue<V> add(U var1);

    public <U extends Value<V>> ArrayValue<V> set(int var1, U var2);

    public <U extends Value<V>> ArrayValue<V> insert(int var1, U var2);

    public Value<V> remove(int var1);

    public <U extends Value<V>> ArrayValue<V> addAll(Collection<U> var1);

    public ArrayValue<V> removeAll();
}

