/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.bayeux.oumuamua.server.api.json;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import org.smallmind.bayeux.oumuamua.server.api.json.BooleanValue;
import org.smallmind.bayeux.oumuamua.server.api.json.ObjectValue;
import org.smallmind.bayeux.oumuamua.server.api.json.StringValue;
import org.smallmind.bayeux.oumuamua.server.api.json.Value;
import org.smallmind.bayeux.oumuamua.server.api.json.ValueType;

public interface Message<V extends Value<V>>
extends ObjectValue<V> {
    public static final String VERSION = "version";
    public static final String MINIMUM_VERSION = "minimumVersion";
    public static final String ID = "id";
    public static final String SESSION_ID = "clientId";
    public static final String CHANNEL = "channel";
    public static final String SUCCESSFUL = "successful";
    public static final String ERROR = "error";
    public static final String CONNECTION_TYPE = "connectionType";
    public static final String SUPPORTED_CONNECTION_TYPES = "supportedConnectionTypes";
    public static final String SUBSCRIPTION = "subscription";
    public static final String EXT = "ext";
    public static final String ADVICE = "advice";
    public static final String DATA = "data";

    default public boolean isSuccessful() {
        Value value = this.get(SUCCESSFUL);
        return value != null && ValueType.BOOLEAN.equals((Object)value.getType()) && ((BooleanValue)value).asBoolean();
    }

    default public String getId() {
        Value value = this.get(ID);
        return value != null && ValueType.STRING.equals((Object)value.getType()) ? ((StringValue)value).asText() : null;
    }

    default public String getSessionId() {
        Value value = this.get(SESSION_ID);
        return value != null && ValueType.STRING.equals((Object)value.getType()) ? ((StringValue)value).asText() : null;
    }

    default public String getChannel() {
        Value value = this.get(CHANNEL);
        return value != null && ValueType.STRING.equals((Object)value.getType()) ? ((StringValue)value).asText() : null;
    }

    default public ObjectValue<V> getAdvice() {
        return this.getAdvice(false);
    }

    default public ObjectValue<V> getAdvice(boolean createIfAbsent) {
        return this.getOrCreate(ADVICE, createIfAbsent);
    }

    default public ObjectValue<V> getExt() {
        return this.getExt(false);
    }

    default public ObjectValue<V> getExt(boolean createIfAbsent) {
        return this.getOrCreate(EXT, createIfAbsent);
    }

    default public ObjectValue<V> getData() {
        return this.getData(false);
    }

    default public ObjectValue<V> getData(boolean createIfAbsent) {
        return this.getOrCreate(DATA, createIfAbsent);
    }

    default public byte[] encode() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);){
            this.encode(outputStreamWriter);
        }
        return outputStream.toByteArray();
    }

    private ObjectValue<V> getOrCreate(String field, boolean createIfAbsent) {
        Value value = this.get(field);
        if (value != null && ValueType.OBJECT.equals((Object)value.getType())) {
            return (ObjectValue)value;
        }
        if (createIfAbsent) {
            ObjectValue createdValue = this.getFactory().objectValue();
            this.put(field, createdValue);
            return createdValue;
        }
        return null;
    }
}

