/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.apache;

import org.apache.commons.logging.Log;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.LoggerManager;

public class CommonsLogWrapper
implements Log {
    private final String name;

    public CommonsLogWrapper(String name) {
        this.name = name;
    }

    private Logger getLogger() {
        return LoggerManager.getLogger((String)this.name);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().getLevel().noGreater(Level.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().getLevel().noGreater(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().getLevel().noGreater(Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().getLevel().noGreater(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().getLevel().noGreater(Level.TRACE);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().getLevel().noGreater(Level.WARN);
    }

    public void trace(Object o) {
        this.getLogger().trace(o);
    }

    public void trace(Object o, Throwable throwable) {
        this.getLogger().trace(throwable, o);
    }

    public void debug(Object o) {
        this.getLogger().debug(o);
    }

    public void debug(Object o, Throwable throwable) {
        this.getLogger().debug(throwable, o);
    }

    public void info(Object o) {
        this.getLogger().info(o);
    }

    public void info(Object o, Throwable throwable) {
        this.getLogger().info(throwable, o);
    }

    public void warn(Object o) {
        this.getLogger().warn(o);
    }

    public void warn(Object o, Throwable throwable) {
        this.getLogger().warn(throwable, o);
    }

    public void error(Object o) {
        this.getLogger().error(o);
    }

    public void error(Object o, Throwable throwable) {
        this.getLogger().error(throwable, o);
    }

    public void fatal(Object o) {
        this.getLogger().fatal(o);
    }

    public void fatal(Object o, Throwable throwable) {
        this.getLogger().fatal(throwable, o);
    }

    static {
        LoggerManager.addLoggingPackagePrefix((String)"org.apache.commons.logging.");
    }
}

