/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.Record;

public abstract class AbstractAppender
implements Appender {
    private Formatter formatter;
    private ErrorHandler errorHandler;
    private ConcurrentLinkedQueue<Filter> filterList;
    private String name;

    public AbstractAppender() {
        this(null, null, null);
    }

    public AbstractAppender(Formatter formatter, ErrorHandler errorHandler) {
        this(null, formatter, errorHandler);
    }

    public AbstractAppender(String name, Formatter formatter, ErrorHandler errorHandler) {
        this.name = name;
        this.formatter = formatter;
        this.errorHandler = errorHandler;
        this.filterList = new ConcurrentLinkedQueue();
    }

    public abstract void handleOutput(String var1) throws Exception;

    public void handleError(ErrorHandler errorHandler, Record record, Exception exception) {
        errorHandler.process(record, exception, "Fatal error in appender(%s)", this.getClass().getCanonicalName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized void clearFilters() {
        this.filterList.clear();
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.filterList.clear();
        this.filterList.add(filter);
    }

    @Override
    public synchronized void setFilters(List<Filter> replacementFilterList) {
        this.filterList.clear();
        this.filterList.addAll(replacementFilterList);
    }

    @Override
    public synchronized void addFilter(Filter filter) {
        this.filterList.add(filter);
    }

    @Override
    public synchronized Filter[] getFilters() {
        Filter[] filters = new Filter[this.filterList.size()];
        this.filterList.toArray(filters);
        return filters;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void publish(Record record) {
        try {
            for (Filter filter : this.filterList) {
                if (filter.willLog(record)) continue;
                return;
            }
            if (this.formatter != null) {
                this.handleOutput(this.formatter.format(record, this.filterList));
            } else if (this.requiresFormatter()) {
                throw new LoggerException("No formatter set for log output on this appender(%s)", this.getClass().getCanonicalName());
            }
        }
        catch (Throwable throwable) {
            if (this.errorHandler == null) {
                throwable.printStackTrace();
            }
            this.handleError(this.errorHandler, record, (Exception)throwable);
        }
    }

    @Override
    public void close() throws LoggerException {
    }
}

