/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.Collection;
import java.util.Date;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.LogicalContext;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.PatternRule;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.Timestamp;
import org.smallmind.scribe.pen.adapter.LoggingBlueprintsFactory;
import org.smallmind.scribe.pen.probe.CompleteOrAbortProbeEntry;
import org.smallmind.scribe.pen.probe.MetricMilieu;
import org.smallmind.scribe.pen.probe.ProbeReport;
import org.smallmind.scribe.pen.probe.Statement;
import org.smallmind.scribe.pen.probe.UpdateProbeEntry;

public class ConversionPatternRule
implements PatternRule {
    private String header;
    private String footer;
    private String multilinePrefix;
    private Padding padding;
    private boolean prefixFirstLine;
    private char conversion;
    private int width;
    private int precision;

    public ConversionPatternRule(String header, String paddingString, String widthString, String precisionString, String firstLineString, String multilinePrefix, String conversionString, String footer) {
        this(header, paddingString == null ? Padding.NONE : (paddingString.equals("+") ? Padding.RIGHT : Padding.LEFT), widthString == null ? -1 : Integer.parseInt(widthString), precisionString == null ? -1 : Integer.parseInt(precisionString), !"-".equals(firstLineString), multilinePrefix == null ? String.valueOf(System.getProperty("line.separator")) + '\t' : multilinePrefix, conversionString.charAt(0), footer);
    }

    public ConversionPatternRule(String header, Padding padding, int width, int precision, boolean prefixFirstLine, String multilinePrefix, char conversion, String footer) {
        this.header = this.stripSlashes(header);
        this.padding = padding;
        this.width = width;
        this.precision = precision;
        this.prefixFirstLine = prefixFirstLine;
        this.multilinePrefix = this.stripSlashes(multilinePrefix);
        this.conversion = conversion;
        this.footer = this.stripSlashes(footer);
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public String getFooter() {
        return this.footer;
    }

    private String stripSlashes(String slashedString) {
        if (slashedString == null) {
            return null;
        }
        boolean slashed = false;
        StringBuffer strippedBuffer = new StringBuffer();
        int count = 0;
        while (count < slashedString.length()) {
            if (slashed) {
                switch (slashedString.charAt(count)) {
                    case 'r': {
                        strippedBuffer.append('\r');
                        break;
                    }
                    case 't': {
                        strippedBuffer.append('\t');
                        break;
                    }
                    case 'f': {
                        strippedBuffer.append('\f');
                        break;
                    }
                    case 'n': {
                        strippedBuffer.append(System.getProperty("line.separator"));
                        break;
                    }
                    default: {
                        strippedBuffer.append(slashedString.charAt(count));
                    }
                }
                slashed = false;
            } else if (slashedString.charAt(count) == '\\') {
                slashed = true;
            } else {
                strippedBuffer.append(slashedString.charAt(count));
            }
            ++count;
        }
        if (slashed) {
            strippedBuffer.append('\\');
        }
        return strippedBuffer.toString();
    }

    @Override
    public String convert(Record record, Collection<Filter> filterCollection, Timestamp timestamp) {
        switch (this.conversion) {
            case 'd': {
                return this.trimToWidthAndPad(timestamp.getTimestamp(new Date(record.getMillis())));
            }
            case 't': {
                return this.trimToWidthAndPad(String.valueOf(record.getMillis()));
            }
            case 'n': {
                return this.trimToWidthAndPad(this.trimToDotPrecision(record.getLoggerName()));
            }
            case 'l': {
                return this.trimToWidthAndPad(record.getLevel().name());
            }
            case 'm': {
                return this.trimToWidthAndPad(record.getMessage());
            }
            case 'T': {
                return this.trimToWidthAndPad(record.getThreadName());
            }
            case 'C': {
                LogicalContext logicalContext = record.getLogicalContext();
                if (logicalContext != null && logicalContext.isFilled()) {
                    return this.trimToWidthAndPad(this.trimToDotPrecision(logicalContext.getClassName()));
                }
                return null;
            }
            case 'M': {
                LogicalContext logicalContext = record.getLogicalContext();
                if (logicalContext != null && logicalContext.isFilled()) {
                    return this.trimToWidthAndPad(logicalContext.getMethodName());
                }
                return null;
            }
            case 'N': {
                LogicalContext logicalContext = record.getLogicalContext();
                if (logicalContext != null && logicalContext.isFilled()) {
                    return this.trimToWidthAndPad(String.valueOf(logicalContext.isNativeMethod()));
                }
                return null;
            }
            case 'L': {
                LogicalContext logicalContext = record.getLogicalContext();
                if (logicalContext != null && logicalContext.isFilled()) {
                    return this.trimToWidthAndPad(String.valueOf(logicalContext.getLineNumber()));
                }
                return null;
            }
            case 'F': {
                LogicalContext logicalContext = record.getLogicalContext();
                if (logicalContext != null && logicalContext.isFilled()) {
                    return this.trimToWidthAndPad(logicalContext.getFileName());
                }
                return null;
            }
            case 'w': {
                Throwable throwable = record.getThrown();
                if (throwable != null) {
                    StringBuilder stackBuilder = new StringBuilder();
                    StackTraceElement[] prevStackTrace = null;
                    if (this.prefixFirstLine && this.multilinePrefix != null) {
                        stackBuilder.append(this.multilinePrefix);
                    }
                    do {
                        if (prevStackTrace == null) {
                            stackBuilder.append("Exception in thread ");
                        } else {
                            if (this.prefixFirstLine && this.multilinePrefix != null) {
                                stackBuilder.append(this.multilinePrefix);
                            }
                            stackBuilder.append("Caused by: ");
                        }
                        stackBuilder.append(throwable.getClass().getCanonicalName());
                        stackBuilder.append(": ");
                        stackBuilder.append(throwable.getMessage());
                        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                        int n = stackTraceElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int repeatedElements;
                            StackTraceElement singleElement = stackTraceElementArray[n2];
                            if (this.multilinePrefix != null) {
                                stackBuilder.append(this.multilinePrefix);
                            }
                            if (prevStackTrace != null && (repeatedElements = ConversionPatternRule.findRepeatedStackElements(singleElement, prevStackTrace)) >= 0) {
                                stackBuilder.append("   ... ");
                                stackBuilder.append(repeatedElements);
                                stackBuilder.append(" more");
                                break;
                            }
                            stackBuilder.append("   at ");
                            stackBuilder.append(singleElement.toString());
                            ++n2;
                        }
                        prevStackTrace = throwable.getStackTrace();
                    } while ((throwable = throwable.getCause()) != null);
                    return stackBuilder.toString();
                }
                return null;
            }
            case 'z': {
                Parameter[] parameters = record.getParameters();
                if (parameters.length > 0) {
                    StringBuilder parameterBuilder = new StringBuilder();
                    int parameterCount = 0;
                    Parameter[] parameterArray = parameters;
                    int n = parameters.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Parameter parameter = parameterArray[n3];
                        if (this.precision > 0 && ++parameterCount > this.precision) break;
                        if ((this.prefixFirstLine || parameterBuilder.length() > 0) && this.multilinePrefix != null) {
                            parameterBuilder.append(this.multilinePrefix);
                        }
                        parameterBuilder.append(parameter.getKey());
                        parameterBuilder.append('=');
                        parameterBuilder.append(parameter.getValue());
                        ++n3;
                    }
                    if (parameterBuilder.length() > 0) {
                        return parameterBuilder.toString();
                    }
                }
                return null;
            }
            case 'p': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null) {
                    return this.trimToWidthAndPad(probeReport.getTitle());
                }
                return null;
            }
            case 'r': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null) {
                    StringBuilder correlatorBuilder = new StringBuilder();
                    if (this.prefixFirstLine && this.multilinePrefix != null) {
                        correlatorBuilder.append(this.multilinePrefix);
                    }
                    correlatorBuilder.append("Thread Identifier: ");
                    correlatorBuilder.append(probeReport.getCorrelator().getThreadIdentifier());
                    if (this.multilinePrefix != null) {
                        correlatorBuilder.append(this.multilinePrefix);
                    }
                    correlatorBuilder.append("Parent Identifier: ");
                    correlatorBuilder.append(probeReport.getCorrelator().getParentIdentifier());
                    if (this.multilinePrefix != null) {
                        correlatorBuilder.append(this.multilinePrefix);
                    }
                    correlatorBuilder.append("Identifier: ");
                    correlatorBuilder.append(probeReport.getCorrelator().getIdentifier());
                    if (this.multilinePrefix != null) {
                        correlatorBuilder.append(this.multilinePrefix);
                    }
                    correlatorBuilder.append("Frame: ");
                    correlatorBuilder.append(probeReport.getCorrelator().getFrame());
                    if (this.multilinePrefix != null) {
                        correlatorBuilder.append(this.multilinePrefix);
                    }
                    correlatorBuilder.append("Instance: ");
                    correlatorBuilder.append(probeReport.getCorrelator().getInstance());
                }
                return null;
            }
            case 's': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null) {
                    return this.trimToWidthAndPad(probeReport.getProbeEntry().getProbeStatus().name());
                }
                return null;
            }
            case 'u': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null && probeReport.getProbeEntry() instanceof UpdateProbeEntry) {
                    return this.trimToWidthAndPad(String.valueOf(((UpdateProbeEntry)probeReport.getProbeEntry()).getUpdateCount()));
                }
                return null;
            }
            case 'i': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null && probeReport.getProbeEntry() instanceof UpdateProbeEntry) {
                    return this.trimToWidthAndPad(String.valueOf(((UpdateProbeEntry)probeReport.getProbeEntry()).getUpdateTime()));
                }
                return null;
            }
            case 'a': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null && probeReport.getProbeEntry() instanceof CompleteOrAbortProbeEntry) {
                    return this.trimToWidthAndPad(String.valueOf(((CompleteOrAbortProbeEntry)probeReport.getProbeEntry()).getStartTime()));
                }
                return null;
            }
            case 'b': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null && probeReport.getProbeEntry() instanceof CompleteOrAbortProbeEntry) {
                    return this.trimToWidthAndPad(String.valueOf(((CompleteOrAbortProbeEntry)probeReport.getProbeEntry()).getStopTime()));
                }
                return null;
            }
            case 'e': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null && probeReport.getProbeEntry() instanceof CompleteOrAbortProbeEntry) {
                    return this.trimToWidthAndPad(String.valueOf(((CompleteOrAbortProbeEntry)probeReport.getProbeEntry()).getStopTime() - ((CompleteOrAbortProbeEntry)probeReport.getProbeEntry()).getStartTime()));
                }
                return null;
            }
            case 'x': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null) {
                    StringBuilder statementBuilder = new StringBuilder();
                    int statementCount = 0;
                    Statement[] statementArray = probeReport.getProbeEntry().getStatements();
                    int n = statementArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Statement statement = statementArray[n4];
                        boolean skipStatement = false;
                        if (this.precision > 0 && ++statementCount > this.precision) break;
                        if (!filterCollection.isEmpty()) {
                            Record filterRecord = LoggingBlueprintsFactory.getLoggingBlueprints().filterRecord(record, statement.getDiscriminator(), statement.getLevel());
                            for (Filter filter : filterCollection) {
                                if (filter.willLog(filterRecord)) continue;
                                skipStatement = true;
                                break;
                            }
                        }
                        if (!skipStatement) {
                            if ((this.prefixFirstLine || statementBuilder.length() > 0) && this.multilinePrefix != null) {
                                statementBuilder.append(this.multilinePrefix);
                            }
                            statementBuilder.append(statement.getMessage());
                        }
                        ++n4;
                    }
                    if (statementBuilder.length() > 0) {
                        return statementBuilder.toString();
                    }
                }
                return null;
            }
            case 'y': {
                ProbeReport probeReport = record.getProbeReport();
                if (probeReport != null) {
                    StringBuilder metricBuilder = new StringBuilder();
                    int metricCount = 0;
                    MetricMilieu[] metricMilieuArray = probeReport.getProbeEntry().getMetricMilieus();
                    int n = metricMilieuArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        MetricMilieu metricMilieu = metricMilieuArray[n5];
                        boolean skipMetric = false;
                        if (this.precision > 0 && ++metricCount > this.precision) break;
                        if (!filterCollection.isEmpty()) {
                            Record filterRecord = LoggingBlueprintsFactory.getLoggingBlueprints().filterRecord(record, metricMilieu.getDiscriminator(), metricMilieu.getLevel());
                            for (Filter filter : filterCollection) {
                                if (filter.willLog(filterRecord)) continue;
                                skipMetric = true;
                                break;
                            }
                        }
                        if (!skipMetric) {
                            boolean listInitiated = false;
                            if ((this.prefixFirstLine || metricBuilder.length() > 0) && this.multilinePrefix != null) {
                                metricBuilder.append(this.multilinePrefix);
                            }
                            metricBuilder.append(metricMilieu.getMetric().getTitle());
                            metricBuilder.append(" [");
                            for (String key : metricMilieu.getMetric().getKeys()) {
                                if (listInitiated) {
                                    metricBuilder.append(", ");
                                }
                                listInitiated = true;
                                metricBuilder.append(key);
                                metricBuilder.append('=');
                                metricBuilder.append(metricMilieu.getMetric().getData(key).toString());
                            }
                            metricBuilder.append("]");
                        }
                        ++n5;
                    }
                    if (metricBuilder.length() > 0) {
                        return metricBuilder.toString();
                    }
                }
                return null;
            }
        }
        throw new UnknownSwitchCaseException("%c", new Object[]{Character.valueOf(this.conversion)});
    }

    private static int findRepeatedStackElements(StackTraceElement singleElement, StackTraceElement[] prevStackTrace) {
        int count = 0;
        while (count < prevStackTrace.length) {
            if (singleElement.equals(prevStackTrace[count])) {
                return prevStackTrace.length - count;
            }
            ++count;
        }
        return -1;
    }

    private String trimToDotPrecision(String field) {
        String[] segments;
        if (field == null) {
            return null;
        }
        if (this.precision > 0 && (segments = field.split("\\.", -1)).length > this.precision) {
            StringBuilder segmentBuilder = new StringBuilder();
            int count = segments.length - this.precision;
            while (count < segments.length) {
                if (count > segments.length - this.precision) {
                    segmentBuilder.append('.');
                }
                segmentBuilder.append(segments[count]);
                ++count;
            }
            return segmentBuilder.toString();
        }
        return field;
    }

    private String trimToWidthAndPad(String field) {
        if (field == null) {
            return null;
        }
        if (field.length() < this.width) {
            switch (this.padding) {
                case NONE: {
                    return field;
                }
                case RIGHT: {
                    StringBuilder paddingBuilder = new StringBuilder(field);
                    int count = 0;
                    while (count < this.width - field.length()) {
                        paddingBuilder.append(' ');
                        ++count;
                    }
                    return paddingBuilder.toString();
                }
                case LEFT: {
                    StringBuilder paddingBuilder = new StringBuilder();
                    int count = 0;
                    while (count < this.width - field.length()) {
                        paddingBuilder.append(' ');
                        ++count;
                    }
                    paddingBuilder.append(field);
                    return paddingBuilder.toString();
                }
            }
            throw new UnknownSwitchCaseException(this.padding.name(), new Object[0]);
        }
        if (this.width > 0) {
            return field.substring(0, this.width);
        }
        return field;
    }

    private static enum Padding {
        LEFT,
        RIGHT,
        NONE;

    }
}

