/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.smallmind.scribe.pen.AbstractAppender;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.Rollover;

public class FileAppender
extends AbstractAppender {
    private BufferedOutputStream fileOutputStream;
    private File logFile;
    private Rollover rollover;
    private boolean closed = false;

    public FileAppender() {
    }

    public FileAppender(String logFilePath) throws IOException {
        this(logFilePath, null, null, null);
    }

    public FileAppender(File logFile) throws IOException {
        this(logFile, null, null, null);
    }

    public FileAppender(String logFilePath, Rollover rollover) throws IOException {
        this(logFilePath, rollover, null, null);
    }

    public FileAppender(File logFile, Rollover rollover) throws IOException {
        this(logFile, rollover, null, null);
    }

    public FileAppender(String logFilePath, Formatter formatter) throws IOException {
        this(logFilePath, null, formatter, null);
    }

    public FileAppender(File logFile, Formatter formatter) throws IOException {
        this(logFile, null, formatter, null);
    }

    public FileAppender(String logFilePath, Rollover rollover, Formatter formatter) throws IOException {
        this(logFilePath, rollover, formatter, null);
    }

    public FileAppender(File logFile, Rollover rollover, Formatter formatter) throws IOException {
        this(logFile, rollover, formatter, null);
    }

    public FileAppender(String logFilePath, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(logFilePath, null, formatter, errorHandler);
    }

    public FileAppender(File logFile, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(logFile, null, formatter, errorHandler);
    }

    public FileAppender(String logFilePath, Rollover rollover, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(new File(logFilePath), rollover, formatter, errorHandler);
    }

    public FileAppender(File logFile, Rollover rollover, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        super(formatter, errorHandler);
        this.rollover = rollover;
        this.setLogFile(logFile);
    }

    @Override
    public boolean requiresFormatter() {
        return true;
    }

    public Rollover getRollover() {
        return this.rollover;
    }

    public void setRollover(Rollover rollover) {
        this.rollover = rollover;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFilePath(String logFilePath) throws IOException {
        this.setLogFile(new File(logFilePath));
    }

    public void setLogFile(File logFile) throws IOException {
        this.logFile = logFile;
        try {
            File parentDirectory = logFile.getParentFile();
            if (parentDirectory != null) {
                parentDirectory.mkdirs();
            }
            logFile.createNewFile();
        }
        catch (IOException iOException) {
            throw new IOException("Error trying to instantiate the requested file(" + logFile.getCanonicalPath() + ")");
        }
        if (!logFile.isFile()) {
            throw new IOException("File must specify a non-directory path(" + logFile.getCanonicalPath() + ")");
        }
        this.fileOutputStream = new BufferedOutputStream(new FileOutputStream(logFile, true));
    }

    @Override
    public synchronized void handleOutput(String formattedOutput) throws LoggerException {
        byte[] formattedBytes = formattedOutput.getBytes();
        if (this.closed) {
            throw new LoggerException("Appender to file(%s) has been previously closed", this.logFile.getAbsolutePath());
        }
        if (this.logFile != null) {
            try {
                if (this.rollover != null && this.rollover.willRollover(this.logFile, formattedBytes.length)) {
                    StringBuilder uniquePathBuilder;
                    File rolloverFile;
                    String logFileName;
                    int dotPos;
                    int uniqueCount = 0;
                    StringBuilder rolloverPathBuilder = new StringBuilder();
                    String parentPath = this.logFile.getParent();
                    if (parentPath != null) {
                        rolloverPathBuilder.append(parentPath);
                        rolloverPathBuilder.append(System.getProperty("file.separator"));
                    }
                    if ((dotPos = (logFileName = this.logFile.getName()).lastIndexOf(46)) >= 0) {
                        rolloverPathBuilder.append(logFileName.substring(0, dotPos));
                    } else {
                        rolloverPathBuilder.append(logFileName);
                    }
                    rolloverPathBuilder.append(this.rollover.getSeparator());
                    rolloverPathBuilder.append(this.rollover.getTimestampSuffix(new Date()));
                    do {
                        uniquePathBuilder = new StringBuilder(rolloverPathBuilder.toString());
                        uniquePathBuilder.append(this.rollover.getSeparator());
                        uniquePathBuilder.append(uniqueCount++);
                        if (dotPos < 0) continue;
                        uniquePathBuilder.append(logFileName.substring(dotPos));
                    } while ((rolloverFile = new File(uniquePathBuilder.toString())).exists());
                    this.fileOutputStream.close();
                    if (!this.logFile.renameTo(rolloverFile)) {
                        throw new LoggerException("Could not rollover the log file to the archive name(%s)", rolloverFile.getAbsolutePath());
                    }
                    if (!this.logFile.createNewFile()) {
                        throw new LoggerException("Could not recreate the log file(%s) after rollover", this.logFile.getAbsolutePath());
                    }
                    this.fileOutputStream = new BufferedOutputStream(new FileOutputStream(this.logFile, true));
                }
                this.fileOutputStream.write(formattedBytes);
                this.fileOutputStream.flush();
            }
            catch (IOException ioException) {
                throw new LoggerException(ioException, "Error attempting to output to file(%s)", this.logFile.getAbsolutePath());
            }
        }
    }

    @Override
    public synchronized void close() throws LoggerException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.fileOutputStream.close();
            }
            catch (IOException ioException) {
                throw new LoggerException(ioException);
            }
        }
    }

    public void finalize() throws LoggerException {
        this.close();
    }
}

