/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.Discriminator;
import org.smallmind.scribe.pen.Enhancer;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.scribe.pen.Template;
import org.smallmind.scribe.pen.adapter.LoggerAdapter;
import org.smallmind.scribe.pen.adapter.LoggingBlueprintsFactory;
import org.smallmind.scribe.pen.probe.Instrument;
import org.smallmind.scribe.pen.probe.InstrumentAndReturn;
import org.smallmind.scribe.pen.probe.Probe;
import org.smallmind.scribe.pen.probe.ProbeException;
import org.smallmind.scribe.pen.probe.ProbeFactory;
import org.smallmind.scribe.pen.probe.ProbeReport;

public class Logger {
    private LoggerAdapter loggerAdapter;

    public Logger(Class loggableClass) {
        this(loggableClass.getCanonicalName());
    }

    public Logger(String name) {
        this.loggerAdapter = LoggingBlueprintsFactory.getLoggingBlueprints().getLoggingAdapter(name);
    }

    public String getName() {
        return this.loggerAdapter.getName();
    }

    public Probe createProbe(Discriminator discriminator, Level level, String title) {
        return ProbeFactory.createProbe(this, discriminator, level == null ? this.getLevel() : level, title);
    }

    public void executeInstrumentation(Instrument instrument) throws ProbeException {
        this.executeInstrumentation(null, null, null, instrument);
    }

    public void executeInstrumentation(Discriminator discriminator, Instrument instrument) throws ProbeException {
        this.executeInstrumentation(discriminator, null, null, instrument);
    }

    public void executeInstrumentation(Level level, Instrument instrument) throws ProbeException {
        this.executeInstrumentation(null, level, null, instrument);
    }

    public void executeInstrumentation(String title, Instrument instrument) throws ProbeException {
        this.executeInstrumentation(null, null, title, instrument);
    }

    public void executeInstrumentation(Discriminator discriminator, String title, Instrument instrument) throws ProbeException {
        this.executeInstrumentation(discriminator, null, title, instrument);
    }

    public void executeInstrumentation(Level level, String title, Instrument instrument) throws ProbeException {
        this.executeInstrumentation(null, level, title, instrument);
    }

    public void executeInstrumentation(Discriminator discriminator, Level level, Instrument instrument) throws ProbeException {
        this.executeInstrumentation(discriminator, level, null, instrument);
    }

    public void executeInstrumentation(Discriminator discriminator, Level level, String title, Instrument instrument) throws ProbeException {
        ProbeFactory.executeInstrumentation(this, discriminator, level == null ? this.getLevel() : level, title, instrument);
    }

    public <T> T executeInstrumentationAndReturn(InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        return this.executeInstrumentationAndReturn(null, null, null, instrumentAndReturn);
    }

    public <T> T executeInstrumentationAndReturn(Discriminator discriminator, InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        return this.executeInstrumentationAndReturn(discriminator, null, null, instrumentAndReturn);
    }

    public <T> T executeInstrumentationAndReturn(Level level, InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        return this.executeInstrumentationAndReturn(null, level, null, instrumentAndReturn);
    }

    public <T> T executeInstrumentationAndReturn(String title, InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        return this.executeInstrumentationAndReturn(null, null, title, instrumentAndReturn);
    }

    public <T> T executeInstrumentationAndReturn(Discriminator discriminator, String title, InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        return this.executeInstrumentationAndReturn(discriminator, null, title, instrumentAndReturn);
    }

    public <T> T executeInstrumentationAndReturn(Level level, String title, InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        return this.executeInstrumentationAndReturn(null, level, title, instrumentAndReturn);
    }

    public <T> T executeInstrumentationAndReturn(Discriminator discriminator, Level level, InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        return this.executeInstrumentationAndReturn(discriminator, level, null, instrumentAndReturn);
    }

    public <T> T executeInstrumentationAndReturn(Discriminator discriminator, Level level, String title, InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        return ProbeFactory.executeInstrumentationAndReturn(this, discriminator, level == null ? this.getLevel() : level, title, instrumentAndReturn);
    }

    public Template getTemplate() {
        return LoggerManager.getTemplate(this);
    }

    public boolean getAutoFillLogicalContext() {
        return this.loggerAdapter.getAutoFillLogicalContext();
    }

    public void setAutoFillLogicalContext(boolean autoFillLogicalContext) {
        this.loggerAdapter.setAutoFillLogicalContext(autoFillLogicalContext);
    }

    public void addFilters(Filter[] filters) {
        Filter[] filterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filter = filterArray[n2];
            this.addFilter(filter);
            ++n2;
        }
    }

    public void addFilter(Filter filter) {
        this.loggerAdapter.addFilter(filter);
    }

    public void clearFilters() {
        this.loggerAdapter.clearFilters();
    }

    public void addAppenders(Appender[] appenders) {
        Appender[] appenderArray = appenders;
        int n = appenders.length;
        int n2 = 0;
        while (n2 < n) {
            Appender appender = appenderArray[n2];
            this.addAppender(appender);
            ++n2;
        }
    }

    public void addAppender(Appender appender) {
        this.loggerAdapter.addAppender(appender);
    }

    public void clearAppenders() {
        this.loggerAdapter.clearAppenders();
    }

    public void addEnhancer(Enhancer enhancer) {
        this.loggerAdapter.addEnhancer(enhancer);
    }

    public void clearEnhancers() {
        this.loggerAdapter.clearEnhancers();
    }

    public Level getLevel() {
        return this.loggerAdapter.getLevel();
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("Can't set a 'null' default level");
        }
        this.loggerAdapter.setLevel(level);
    }

    public void trace(Throwable throwable) {
        this.log(Level.TRACE, throwable);
    }

    public void trace(Discriminator discriminator, Throwable throwable) {
        this.log(discriminator, Level.TRACE, throwable);
    }

    public void trace(String message, Object ... args) {
        this.log(Level.TRACE, message, args);
    }

    public void trace(Discriminator discriminator, String message, Object ... args) {
        this.log(discriminator, Level.TRACE, message, args);
    }

    public void trace(Throwable throwable, String message, Object ... args) {
        this.log(Level.TRACE, throwable, message, args);
    }

    public void trace(Discriminator discriminator, Throwable throwable, String message, Object ... args) {
        this.log(discriminator, Level.TRACE, throwable, message, args);
    }

    public void trace(Object object) {
        this.log(Level.TRACE, object);
    }

    public void trace(Discriminator discriminator, Object object) {
        this.log(discriminator, Level.TRACE, object);
    }

    public void trace(Throwable throwable, Object object) {
        this.log(Level.TRACE, throwable, object);
    }

    public void trace(Discriminator discriminator, Throwable throwable, Object object) {
        this.log(discriminator, Level.TRACE, throwable, object);
    }

    public void debug(Throwable throwable) {
        this.log(Level.DEBUG, throwable);
    }

    public void debug(Discriminator discriminator, Throwable throwable) {
        this.log(discriminator, Level.DEBUG, throwable);
    }

    public void debug(String message, Object ... args) {
        this.log(Level.DEBUG, message, args);
    }

    public void debug(Discriminator discriminator, String message, Object ... args) {
        this.log(discriminator, Level.DEBUG, message, args);
    }

    public void debug(Throwable throwable, String message, Object ... args) {
        this.log(Level.DEBUG, throwable, message, args);
    }

    public void debug(Discriminator discriminator, Throwable throwable, String message, Object ... args) {
        this.log(discriminator, Level.DEBUG, throwable, message, args);
    }

    public void debug(Object object) {
        this.log(Level.DEBUG, object);
    }

    public void debug(Discriminator discriminator, Object object) {
        this.log(discriminator, Level.DEBUG, object);
    }

    public void debug(Throwable throwable, Object object) {
        this.log(Level.DEBUG, throwable, object);
    }

    public void debug(Discriminator discriminator, Throwable throwable, Object object) {
        this.log(discriminator, Level.DEBUG, throwable, object);
    }

    public void info(Throwable throwable) {
        this.log(Level.INFO, throwable);
    }

    public void info(Discriminator discriminator, Throwable throwable) {
        this.log(discriminator, Level.INFO, throwable);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    public void info(Discriminator discriminator, String message, Object ... args) {
        this.log(discriminator, Level.INFO, message, args);
    }

    public void info(Throwable throwable, String message, Object ... args) {
        this.log(Level.INFO, throwable, message, args);
    }

    public void info(Discriminator discriminator, Throwable throwable, String message, Object ... args) {
        this.log(discriminator, Level.INFO, throwable, message, args);
    }

    public void info(Object object) {
        this.log(Level.INFO, object);
    }

    public void info(Discriminator discriminator, Object object) {
        this.log(discriminator, Level.INFO, object);
    }

    public void info(Throwable throwable, Object object) {
        this.log(Level.INFO, throwable, object);
    }

    public void info(Discriminator discriminator, Throwable throwable, Object object) {
        this.log(discriminator, Level.INFO, throwable, object);
    }

    public void warn(Throwable throwable) {
        this.log(Level.WARN, throwable);
    }

    public void warn(Discriminator discriminator, Throwable throwable) {
        this.log(discriminator, Level.WARN, throwable);
    }

    public void warn(String message, Object ... args) {
        this.log(Level.WARN, message, args);
    }

    public void warn(Discriminator discriminator, String message, Object ... args) {
        this.log(discriminator, Level.WARN, message, args);
    }

    public void warn(Throwable throwable, String message, Object ... args) {
        this.log(Level.WARN, throwable, message, args);
    }

    public void warn(Discriminator discriminator, Throwable throwable, String message, Object ... args) {
        this.log(discriminator, Level.WARN, throwable, message, args);
    }

    public void warn(Object object) {
        this.log(Level.WARN, object);
    }

    public void warn(Discriminator discriminator, Object object) {
        this.log(discriminator, Level.WARN, object);
    }

    public void warn(Throwable throwable, Object object) {
        this.log(Level.WARN, throwable, object);
    }

    public void warn(Discriminator discriminator, Throwable throwable, Object object) {
        this.log(discriminator, Level.WARN, throwable, object);
    }

    public void error(Throwable throwable) {
        this.log(Level.ERROR, throwable);
    }

    public void error(Discriminator discriminator, Throwable throwable) {
        this.log(discriminator, Level.ERROR, throwable);
    }

    public void error(String message, Object ... args) {
        this.log(Level.ERROR, message, args);
    }

    public void error(Discriminator discriminator, String message, Object ... args) {
        this.log(discriminator, Level.ERROR, message, args);
    }

    public void error(Throwable throwable, String message, Object ... args) {
        this.log(Level.ERROR, throwable, message, args);
    }

    public void error(Discriminator discriminator, Throwable throwable, String message, Object ... args) {
        this.log(discriminator, Level.ERROR, throwable, message, args);
    }

    public void error(Object object) {
        this.log(Level.ERROR, object);
    }

    public void error(Discriminator discriminator, Object object) {
        this.log(discriminator, Level.ERROR, object);
    }

    public void error(Throwable throwable, Object object) {
        this.log(Level.ERROR, throwable, object);
    }

    public void error(Discriminator discriminator, Throwable throwable, Object object) {
        this.log(discriminator, Level.ERROR, throwable, object);
    }

    public void fatal(Throwable throwable) {
        this.log(Level.FATAL, throwable);
    }

    public void fatal(Discriminator discriminator, Throwable throwable) {
        this.log(discriminator, Level.FATAL, throwable);
    }

    public void fatal(String message, Object ... args) {
        this.log(Level.FATAL, message, args);
    }

    public void fatal(Discriminator discriminator, String message, Object ... args) {
        this.log(discriminator, Level.FATAL, message, args);
    }

    public void fatal(Throwable throwable, String message, Object ... args) {
        this.log(Level.FATAL, throwable, message, args);
    }

    public void fatal(Discriminator discriminator, Throwable throwable, String message, Object ... args) {
        this.log(discriminator, Level.FATAL, throwable, message, args);
    }

    public void fatal(Object object) {
        this.log(Level.FATAL, object);
    }

    public void fatal(Discriminator discriminator, Object object) {
        this.log(discriminator, Level.FATAL, object);
    }

    public void fatal(Throwable throwable, Object object) {
        this.log(Level.FATAL, throwable, object);
    }

    public void fatal(Discriminator discriminator, Throwable throwable, Object object) {
        this.log(discriminator, Level.FATAL, throwable, object);
    }

    public void log(Level level, Throwable throwable) {
        this.loggerAdapter.logMessage(null, level == null ? this.getLevel() : level, throwable, null);
    }

    public void log(Discriminator discriminator, Level level, Throwable throwable) {
        this.loggerAdapter.logMessage(discriminator, level == null ? this.getLevel() : level, throwable, null);
    }

    public void log(Level level, String message, Object ... args) {
        this.loggerAdapter.logMessage(null, level == null ? this.getLevel() : level, null, message, args);
    }

    public void log(Discriminator discriminator, Level level, String message, Object ... args) {
        this.loggerAdapter.logMessage(discriminator, level == null ? this.getLevel() : level, null, message, args);
    }

    public void log(Level level, Throwable throwable, String message, Object ... args) {
        this.loggerAdapter.logMessage(null, level == null ? this.getLevel() : level, throwable, message, args);
    }

    public void log(Discriminator discriminator, Level level, Throwable throwable, String message, Object ... args) {
        this.loggerAdapter.logMessage(discriminator, level == null ? this.getLevel() : level, throwable, message, args);
    }

    public void log(Level level, ProbeReport probeReport) {
        this.loggerAdapter.logProbe(null, level == null ? this.getLevel() : level, null, probeReport);
    }

    public void log(Discriminator discriminator, Level level, ProbeReport probeReport) {
        this.loggerAdapter.logProbe(discriminator, level == null ? this.getLevel() : level, null, probeReport);
    }

    public void log(Level level, Throwable throwable, ProbeReport probeReport) {
        this.loggerAdapter.logProbe(null, level == null ? this.getLevel() : level, throwable, probeReport);
    }

    public void log(Discriminator discriminator, Level level, Throwable throwable, ProbeReport probeReport) {
        this.loggerAdapter.logProbe(discriminator, level == null ? this.getLevel() : level, throwable, probeReport);
    }

    public void log(Level level, Object object) {
        this.loggerAdapter.logMessage(null, level == null ? this.getLevel() : level, null, object);
    }

    public void log(Discriminator discriminator, Level level, Object object) {
        this.loggerAdapter.logMessage(discriminator, level == null ? this.getLevel() : level, null, object);
    }

    public void log(Level level, Throwable throwable, Object object) {
        this.loggerAdapter.logMessage(null, level == null ? this.getLevel() : level, throwable, object);
    }

    public void log(Discriminator discriminator, Level level, Throwable throwable, Object object) {
        this.loggerAdapter.logMessage(discriminator, level == null ? this.getLevel() : level, throwable, object);
    }
}

