/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogIF;
import org.smallmind.scribe.pen.AbstractAppender;

public class SyslogAppender
extends AbstractAppender {
    private SyslogIF udpSyslog;
    private int pri;
    private int size;

    public SyslogAppender(String host, int port, int pri) {
        this.pri = pri;
        this.udpSyslog = Syslog.getInstance((String)"udp");
        this.udpSyslog.getConfig().setHost(host);
        this.udpSyslog.getConfig().setPort(port);
        this.size = this.udpSyslog.getConfig().getMaxMessageLength();
    }

    @Override
    public void handleOutput(String output) throws Exception {
        if (this.size < output.length()) {
            this.updateSize(output.length());
        }
        this.udpSyslog.log(this.pri, output);
    }

    private synchronized void updateSize(int upperSize) {
        if (this.size < upperSize) {
            this.size = upperSize;
        }
    }

    @Override
    public boolean requiresFormatter() {
        return true;
    }
}

