/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.File;
import java.util.Calendar;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.Rollover;
import org.smallmind.scribe.pen.Timestamp;
import org.smallmind.scribe.pen.TimestampQuantifier;

public class TimestampRollover
extends Rollover {
    private TimestampQuantifier timestampQuantifier;

    public TimestampRollover() {
        this(TimestampQuantifier.TOP_OF_DAY);
    }

    public TimestampRollover(TimestampQuantifier timestampQuantifier) {
        this.timestampQuantifier = timestampQuantifier;
    }

    public TimestampRollover(TimestampQuantifier timestampQuantifier, char separator, Timestamp timestamp) {
        super(separator, timestamp);
        this.timestampQuantifier = timestampQuantifier;
    }

    public TimestampQuantifier getTimestampQuantifier() {
        return this.timestampQuantifier;
    }

    public void setTimestampQuantifier(TimestampQuantifier timestampQuantifier) {
        this.timestampQuantifier = timestampQuantifier;
    }

    @Override
    public boolean willRollover(File logFile, long bytesToBeWritten) {
        Calendar now = Calendar.getInstance();
        Calendar lastMod = Calendar.getInstance();
        lastMod.setTimeInMillis(logFile.lastModified());
        switch (this.timestampQuantifier) {
            case TOP_OF_MINUTE: {
                return now.get(1) != lastMod.get(1) || now.get(2) != lastMod.get(2) || now.get(5) != lastMod.get(5) || now.get(11) != lastMod.get(11) || now.get(12) != lastMod.get(12);
            }
            case TOP_OF_HOUR: {
                return now.get(1) != lastMod.get(1) || now.get(2) != lastMod.get(2) || now.get(5) != lastMod.get(5) || now.get(11) != lastMod.get(11);
            }
            case HALF_DAY: {
                return now.get(1) != lastMod.get(1) || now.get(2) != lastMod.get(2) || now.get(5) != lastMod.get(5) || now.get(9) != lastMod.get(9);
            }
            case TOP_OF_DAY: {
                return now.get(1) != lastMod.get(1) || now.get(2) != lastMod.get(2) || now.get(5) != lastMod.get(5);
            }
            case TOP_OF_WEEK: {
                return now.get(1) != lastMod.get(1) || now.get(2) != lastMod.get(2) || now.get(4) != lastMod.get(4);
            }
            case TOP_OF_MONTH: {
                return now.get(1) != lastMod.get(1) || now.get(2) != lastMod.get(2);
            }
        }
        throw new UnknownSwitchCaseException(this.timestampQuantifier.name(), new Object[0]);
    }
}

