/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.DateFormatTimestamp;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LogicalContext;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.Timestamp;
import org.smallmind.scribe.pen.XMLElement;
import org.smallmind.scribe.pen.adapter.LoggingBlueprintsFactory;
import org.smallmind.scribe.pen.probe.CompleteOrAbortProbeEntry;
import org.smallmind.scribe.pen.probe.Correlator;
import org.smallmind.scribe.pen.probe.MetricMilieu;
import org.smallmind.scribe.pen.probe.ProbeEntry;
import org.smallmind.scribe.pen.probe.ProbeReport;
import org.smallmind.scribe.pen.probe.Statement;
import org.smallmind.scribe.pen.probe.UpdateProbeEntry;

public class XMLFormatter
implements Formatter {
    private Timestamp timestamp;
    private XMLElement[] xmlElements;
    private int indent;

    public XMLFormatter() {
        this(3, XMLElement.values(), DateFormatTimestamp.getDefaultInstance());
    }

    public XMLFormatter(Timestamp timestamp) {
        this(3, XMLElement.values(), timestamp);
    }

    public XMLFormatter(int indent) {
        this(indent, XMLElement.values(), DateFormatTimestamp.getDefaultInstance());
    }

    public XMLFormatter(int indent, Timestamp timestamp) {
        this(indent, XMLElement.values(), timestamp);
    }

    public XMLFormatter(XMLElement[] xmlElements) {
        this(3, xmlElements, DateFormatTimestamp.getDefaultInstance());
    }

    public XMLFormatter(XMLElement[] xmlElements, Timestamp timestamp) {
        this(3, xmlElements, timestamp);
    }

    public XMLFormatter(int indent, XMLElement[] xmlElements) {
        this(indent, xmlElements, DateFormatTimestamp.getDefaultInstance());
    }

    public XMLFormatter(int indent, XMLElement[] xmlElements, Timestamp timestamp) {
        this.indent = indent;
        this.xmlElements = xmlElements;
        this.timestamp = timestamp;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public XMLElement[] getXmlElements() {
        return this.xmlElements;
    }

    public void setXmlElements(XMLElement[] xmlElements) {
        this.xmlElements = xmlElements;
    }

    @Override
    public String format(Record record, Collection<Filter> filterCollection) {
        StringBuilder formatBuilder = new StringBuilder();
        this.appendLine(formatBuilder, "<log-record>", 0);
        XMLElement[] xMLElementArray = this.xmlElements;
        int n = this.xmlElements.length;
        int n2 = 0;
        while (n2 < n) {
            XMLElement xmlElement = xMLElementArray[n2];
            switch (xmlElement) {
                case DATE: {
                    this.appendElement(formatBuilder, "date", this.timestamp.getTimestamp(new Date(record.getMillis())), 1);
                    break;
                }
                case MILLISECONDS: {
                    this.appendElement(formatBuilder, "milliseconds", String.valueOf(record.getMillis()), 1);
                    break;
                }
                case LOGGER_NAME: {
                    this.appendElement(formatBuilder, "logger", record.getLoggerName(), 1);
                    break;
                }
                case LEVEL: {
                    this.appendElement(formatBuilder, "level", record.getLevel().name(), 1);
                    break;
                }
                case MESSAGE: {
                    this.appendElement(formatBuilder, "message", record.getMessage(), 1);
                    break;
                }
                case THREAD: {
                    this.appendThreadInfo(formatBuilder, record.getThreadName(), record.getThreadID(), 1);
                    break;
                }
                case LOGICAL_CONTEXT: {
                    this.appendLogicalContext(formatBuilder, record.getLogicalContext(), 1);
                    break;
                }
                case PARAMETERS: {
                    this.appendParameters(formatBuilder, record.getParameters(), 1);
                    break;
                }
                case STACK_TRACE: {
                    this.appendStackTrace(formatBuilder, record.getThrown(), 1);
                    break;
                }
                case PROBE_REPORT: {
                    this.appendProbeReport(formatBuilder, record, record.getProbeReport(), filterCollection, 1);
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(xmlElement.name(), new Object[0]);
                }
            }
            ++n2;
        }
        this.appendLine(formatBuilder, "</log-record>", 0);
        return formatBuilder.toString();
    }

    private void appendThreadInfo(StringBuilder formatBuilder, String threadName, long threadId, int level) {
        if (threadName != null || threadId > 0L) {
            this.appendLine(formatBuilder, "<thread>", level);
            this.appendElement(formatBuilder, "name", threadName, level + 1);
            this.appendElement(formatBuilder, "id", threadId > 0L ? String.valueOf(threadId) : null, level + 1);
            this.appendLine(formatBuilder, "</thread>", level);
        }
    }

    private void appendLogicalContext(StringBuilder formatBuilder, LogicalContext logicalContext, int level) {
        if (logicalContext != null && logicalContext.isFilled()) {
            this.appendLine(formatBuilder, "<context>", level);
            this.appendElement(formatBuilder, "class", logicalContext.getClassName(), level + 1);
            this.appendElement(formatBuilder, "method", logicalContext.getMethodName(), level + 1);
            this.appendElement(formatBuilder, "native", String.valueOf(logicalContext.isNativeMethod()), level + 1);
            this.appendElement(formatBuilder, "line", !logicalContext.isNativeMethod() && logicalContext.getLineNumber() > 0 ? String.valueOf(logicalContext.getLineNumber()) : null, level + 1);
            this.appendElement(formatBuilder, "file", logicalContext.getFileName(), level + 1);
            this.appendLine(formatBuilder, "</context>", level);
        }
    }

    private void appendParameters(StringBuilder formatBuilder, Parameter[] parameters, int level) {
        if (parameters.length > 0) {
            this.appendLine(formatBuilder, "<parameters>", level);
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                this.appendElement(formatBuilder, parameter.getKey(), parameter.getValue().toString(), level + 1);
                ++n2;
            }
            this.appendLine(formatBuilder, "</parameters>", level);
        }
    }

    private void appendStackTrace(StringBuilder formatBuilder, Throwable throwable, int level) {
        StackTraceElement[] prevStackTrace = null;
        if (throwable != null) {
            this.appendLine(formatBuilder, "<stack-trace>", level);
            do {
                this.appendIndent(formatBuilder, level + 1);
                if (prevStackTrace == null) {
                    formatBuilder.append("Exception in thread ");
                } else {
                    formatBuilder.append("Caused by: ");
                }
                formatBuilder.append(throwable.getClass().getCanonicalName());
                formatBuilder.append(": ");
                formatBuilder.append(throwable.getMessage());
                formatBuilder.append(System.getProperty("line.separator"));
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int repeatedElements;
                    StackTraceElement singleElement = stackTraceElementArray[n2];
                    this.appendIndent(formatBuilder, level + 1);
                    if (prevStackTrace != null && (repeatedElements = XMLFormatter.findRepeatedStackElements(singleElement, prevStackTrace)) >= 0) {
                        formatBuilder.append("   ... ");
                        formatBuilder.append(repeatedElements);
                        formatBuilder.append(" more");
                        formatBuilder.append(System.getProperty("line.separator"));
                        break;
                    }
                    formatBuilder.append("   at ");
                    formatBuilder.append(singleElement.toString());
                    formatBuilder.append(System.getProperty("line.separator"));
                    ++n2;
                }
                prevStackTrace = throwable.getStackTrace();
            } while ((throwable = throwable.getCause()) != null);
            this.appendLine(formatBuilder, "</stack-trace>", level);
        }
    }

    private static int findRepeatedStackElements(StackTraceElement singleElement, StackTraceElement[] prevStackTrace) {
        int count = 0;
        while (count < prevStackTrace.length) {
            if (singleElement.equals(prevStackTrace[count])) {
                return prevStackTrace.length - count;
            }
            ++count;
        }
        return -1;
    }

    private void appendProbeReport(StringBuilder formatBuilder, Record record, ProbeReport probeReport, Collection<Filter> filterCollection, int level) {
        if (probeReport != null) {
            this.appendLine(formatBuilder, "<probe-report>", level);
            this.appendElement(formatBuilder, "first", String.valueOf(probeReport.isFirst()), level + 1);
            this.appendCorrelator(formatBuilder, probeReport.getCorrelator(), level + 1);
            this.appendProbeEntry(formatBuilder, record, probeReport.getProbeEntry(), filterCollection, level + 1);
            this.appendLine(formatBuilder, "</probe-report>", level);
        }
    }

    private void appendCorrelator(StringBuilder formatBuilder, Correlator correlator, int level) {
        this.appendLine(formatBuilder, "<correlator>", level);
        this.appendElement(formatBuilder, "thread-identifier", Arrays.toString(correlator.getThreadIdentifier()), level + 1);
        this.appendElement(formatBuilder, "parent-identifier", Arrays.toString(correlator.getParentIdentifier()), level + 1);
        this.appendElement(formatBuilder, "identifier", Arrays.toString(correlator.getIdentifier()), level + 1);
        this.appendElement(formatBuilder, "frame", String.valueOf(correlator.getFrame()), level + 1);
        this.appendElement(formatBuilder, "instance", String.valueOf(correlator.getInstance()), level + 1);
        this.appendLine(formatBuilder, "</correlator>", level);
    }

    private void appendProbeEntry(StringBuilder formatBuilder, Record record, ProbeEntry probeEntry, Collection<Filter> filterCollection, int level) {
        if (probeEntry != null) {
            Record filterRecord;
            this.appendLine(formatBuilder, "<probe-entry>", level);
            this.appendElement(formatBuilder, "status", probeEntry.getProbeStatus().name(), level + 1);
            if (probeEntry instanceof UpdateProbeEntry) {
                this.appendElement(formatBuilder, "updated", String.valueOf(((UpdateProbeEntry)probeEntry).getUpdateTime()), level + 1);
                this.appendElement(formatBuilder, "count", String.valueOf(((UpdateProbeEntry)probeEntry).getUpdateCount()), level + 1);
            } else if (probeEntry instanceof CompleteOrAbortProbeEntry) {
                this.appendElement(formatBuilder, "started", String.valueOf(((CompleteOrAbortProbeEntry)probeEntry).getStartTime()), level + 1);
                this.appendElement(formatBuilder, "stopped", String.valueOf(((CompleteOrAbortProbeEntry)probeEntry).getStopTime()), level + 1);
                this.appendElement(formatBuilder, "elapsed", String.valueOf(((CompleteOrAbortProbeEntry)probeEntry).getStopTime() - ((CompleteOrAbortProbeEntry)probeEntry).getStartTime()), level + 1);
            } else {
                throw new IllegalArgumentException("Unknown instance type of ProbeEntry(" + probeEntry.getClass().getCanonicalName() + ")");
            }
            Serializable[] serializableArray = probeEntry.getStatements();
            int n = serializableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = serializableArray[n2];
                boolean skipStatement = false;
                if (!filterCollection.isEmpty()) {
                    filterRecord = LoggingBlueprintsFactory.getLoggingBlueprints().filterRecord(record, statement.getDiscriminator(), statement.getLevel());
                    for (Filter filter : filterCollection) {
                        if (filter.willLog(filterRecord)) continue;
                        skipStatement = true;
                        break;
                    }
                }
                if (!skipStatement) {
                    this.appendElement(formatBuilder, "statement", statement.getMessage(), level + 1);
                }
                ++n2;
            }
            serializableArray = probeEntry.getMetricMilieus();
            n = serializableArray.length;
            n2 = 0;
            while (n2 < n) {
                Serializable metricMilieu = serializableArray[n2];
                boolean skipMetric = false;
                if (!filterCollection.isEmpty()) {
                    filterRecord = LoggingBlueprintsFactory.getLoggingBlueprints().filterRecord(record, ((MetricMilieu)metricMilieu).getDiscriminator(), ((MetricMilieu)metricMilieu).getLevel());
                    for (Filter filter : filterCollection) {
                        if (filter.willLog(filterRecord)) continue;
                        skipMetric = true;
                        break;
                    }
                }
                if (!skipMetric) {
                    this.appendLine(formatBuilder, "<" + ((MetricMilieu)metricMilieu).getMetric().getTitle() + ">", level + 1);
                    for (String key : ((MetricMilieu)metricMilieu).getMetric().getKeys()) {
                        this.appendElement(formatBuilder, key, ((MetricMilieu)metricMilieu).getMetric().getData(key).toString(), level + 2);
                    }
                    this.appendLine(formatBuilder, "</" + ((MetricMilieu)metricMilieu).getMetric().getTitle() + ">", level + 1);
                }
                ++n2;
            }
            this.appendLine(formatBuilder, "</probe-entry>", level);
        }
    }

    private void appendElement(StringBuilder formatBuilder, String tagName, String value, int level) {
        if (value != null) {
            this.appendIndent(formatBuilder, level);
            formatBuilder.append("<");
            formatBuilder.append(tagName);
            formatBuilder.append(">");
            formatBuilder.append(value);
            formatBuilder.append("</");
            formatBuilder.append(tagName);
            formatBuilder.append(">");
            formatBuilder.append(System.getProperty("line.separator"));
        }
    }

    private void appendLine(StringBuilder formatBuilder, String content, int level) {
        this.appendIndent(formatBuilder, level);
        formatBuilder.append(content);
        formatBuilder.append(System.getProperty("line.separator"));
    }

    private void appendIndent(StringBuilder formatBuilder, int level) {
        int count = 0;
        while (count < level * this.indent) {
            formatBuilder.append(" ");
            ++count;
        }
    }
}

