/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen.probe;

import java.util.LinkedList;
import org.smallmind.scribe.pen.Discriminator;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.probe.CompleteOrAbortProbeEntry;
import org.smallmind.scribe.pen.probe.Correlator;
import org.smallmind.scribe.pen.probe.Metric;
import org.smallmind.scribe.pen.probe.MetricMilieu;
import org.smallmind.scribe.pen.probe.ProbeException;
import org.smallmind.scribe.pen.probe.ProbeFactory;
import org.smallmind.scribe.pen.probe.ProbeReport;
import org.smallmind.scribe.pen.probe.ProbeStatus;
import org.smallmind.scribe.pen.probe.Statement;
import org.smallmind.scribe.pen.probe.UpdateProbeEntry;

public class Probe {
    private LinkedList<MetricMilieu> metricMilieuList;
    private LinkedList<Statement> statementList;
    public Logger logger;
    public Discriminator discriminator;
    public Level level;
    private Correlator correlator;
    private String title;
    private boolean first;
    private boolean aborted = false;
    private long startTime;
    private long stopTime;
    private int updateCount = 0;

    protected Probe(Logger logger, Discriminator discriminator, Level level, Correlator correlator, String title, boolean first) {
        this.logger = logger;
        this.discriminator = discriminator;
        this.level = level;
        this.correlator = correlator;
        this.title = title;
        this.first = first;
        this.metricMilieuList = new LinkedList();
        this.statementList = new LinkedList();
    }

    public void logMessage(String message, Object ... args) {
        this.logger.log(this.discriminator, this.level, message, args);
    }

    public void logMessage(Discriminator discriminator, String message, Object ... args) {
        this.logger.log(discriminator, this.level, message, args);
    }

    public void logMessage(Level level, String message, Object ... args) {
        this.logger.log(this.discriminator, level, message, args);
    }

    public void logMessage(Discriminator discriminator, Level level, String message, Object ... args) {
        this.logger.log(discriminator, level, message, args);
    }

    protected Correlator getCorrelator() {
        return this.correlator;
    }

    protected LinkedList<MetricMilieu> getMetricMilieuList() {
        return this.metricMilieuList;
    }

    public void addMetric(Metric metric) {
        this.metricMilieuList.add(new MetricMilieu(this.discriminator, this.level, metric));
    }

    public void addMetric(Discriminator discriminator, Metric metric) {
        this.metricMilieuList.add(new MetricMilieu(discriminator, this.level, metric));
    }

    public void addMetric(Level level, Metric metric) {
        this.metricMilieuList.add(new MetricMilieu(this.discriminator, level, metric));
    }

    public void addMetric(Discriminator discriminator, Level level, Metric metric) {
        this.metricMilieuList.add(new MetricMilieu(discriminator, level, metric));
    }

    protected LinkedList<Statement> getStatementList() {
        return this.statementList;
    }

    public void addStatement(String message, Object ... args) {
        this.statementList.add(new Statement(this.discriminator, this.level, message, args));
    }

    public void addStatement(Discriminator discriminator, String message, Object ... args) {
        this.statementList.add(new Statement(discriminator, this.level, message, args));
    }

    public void addStatement(Level level, String message, Object ... args) {
        this.statementList.add(new Statement(this.discriminator, level, message, args));
    }

    public void addStatement(Discriminator discriminator, Level level, String message, Object ... args) {
        this.statementList.add(new Statement(discriminator, level, message, args));
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Probe start() throws ProbeException {
        if (this.startTime != 0L) {
            throw new ProbeException("Probe has already been started", new Object[0]);
        }
        this.startTime = System.currentTimeMillis();
        return this;
    }

    public void update() throws ProbeException {
        this.update(null);
    }

    public void update(Throwable throwable) throws ProbeException {
        if (this.startTime == 0L) {
            throw (ProbeException)((Object)new ProbeException("Probe has not been started", new Object[0]).initCause(throwable));
        }
        if (this.stopTime != 0L) {
            throw (ProbeException)((Object)new ProbeException("Probe has already been terminated", new Object[0]).initCause(throwable));
        }
        this.logger.log(this.discriminator, this.level, throwable, new ProbeReport(this.correlator, this.title, new UpdateProbeEntry(this, System.currentTimeMillis(), this.updateCount++), this.first));
        this.statementList.clear();
    }

    public void stop() throws ProbeException {
        if (this.startTime == 0L) {
            throw new ProbeException("Probe has not been started", new Object[0]);
        }
        if (this.stopTime < 0L) {
            throw new ProbeException("Attempting to stop Probe after it has already been aborted", new Object[0]);
        }
        this.stopTime = System.currentTimeMillis();
        this.logger.log(this.discriminator, this.level, new ProbeReport(this.correlator, this.title, new CompleteOrAbortProbeEntry(ProbeStatus.COMPLETED, this, this.startTime, this.stopTime), this.first));
        this.statementList.clear();
        ProbeFactory.closeProbe(this);
    }

    public void abort() throws ProbeException {
        this.abort(null);
    }

    public void abort(Throwable throwable) throws ProbeException {
        if (this.startTime == 0L) {
            ProbeException probeException = (ProbeException)((Object)new ProbeException("Probe has not been started", new Object[0]).initCause(throwable));
            throw probeException;
        }
        if (this.stopTime != 0L) {
            throw (ProbeException)((Object)new ProbeException("Attempting to abort Probe after at has already been stopped", new Object[0]).initCause(throwable));
        }
        this.aborted = true;
        this.logger.log(this.discriminator, this.level, throwable, new ProbeReport(this.correlator, this.title, new CompleteOrAbortProbeEntry(ProbeStatus.ABORTED, this, this.startTime, System.currentTimeMillis()), this.first));
        this.statementList.clear();
        this.stopTime = -1L;
        try {
            ProbeFactory.closeProbe(this);
        }
        catch (ProbeException probeException) {
            if (probeException.getCause() == probeException) {
                probeException.initCause(throwable);
            }
            throw probeException;
        }
    }

    public int hashCode() {
        return this.correlator.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Probe && this.correlator.equals(((Probe)obj).getCorrelator());
    }
}

