/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.scribe.pen.Record;

public class AsynchronousAppender
implements Appender,
Runnable {
    private CountDownLatch exitLatch;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private Appender internalAppender;
    private LinkedBlockingQueue<Record> publishQueue;

    public AsynchronousAppender(Appender internalAppender) {
        this(internalAppender, Integer.MAX_VALUE);
    }

    public AsynchronousAppender(Appender internalAppender, int bufferSize) {
        this.internalAppender = internalAppender;
        this.publishQueue = new LinkedBlockingQueue();
        this.exitLatch = new CountDownLatch(1);
        Thread publishThread = new Thread(this);
        publishThread.setDaemon(true);
        publishThread.start();
    }

    @Override
    public void setName(String name) {
        this.internalAppender.setName(name);
    }

    @Override
    public String getName() {
        return this.internalAppender.getName();
    }

    @Override
    public void clearFilters() {
        this.internalAppender.clearFilters();
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.internalAppender.setFilter(filter);
    }

    @Override
    public void setFilters(List<Filter> filterList) {
        this.internalAppender.setFilters(filterList);
    }

    @Override
    public void addFilter(Filter filter) {
        this.internalAppender.addFilter(filter);
    }

    @Override
    public Filter[] getFilters() {
        return this.internalAppender.getFilters();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.internalAppender.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.internalAppender.setErrorHandler(errorHandler);
    }

    @Override
    public void setFormatter(Formatter formatter) {
        this.internalAppender.setFormatter(formatter);
    }

    @Override
    public Formatter getFormatter() {
        return this.internalAppender.getFormatter();
    }

    @Override
    public boolean requiresFormatter() {
        return this.internalAppender.requiresFormatter();
    }

    @Override
    public void publish(Record record) {
        try {
            if (this.finished.get()) {
                throw new LoggerException("%s has been previously closed", this.getClass().getSimpleName());
            }
            this.publishQueue.put(record);
        }
        catch (Exception exception) {
            if (this.internalAppender.getErrorHandler() == null) {
                exception.printStackTrace();
            }
            this.internalAppender.getErrorHandler().process(record, exception, "Fatal error in appender(%s)", this.getClass().getCanonicalName());
        }
    }

    @Override
    public void close() throws LoggerException {
        try {
            this.finish();
        }
        catch (InterruptedException interuptedException) {
            throw new LoggerException(interuptedException);
        }
        this.internalAppender.close();
    }

    public void finish() throws InterruptedException {
        this.finished.compareAndSet(false, true);
        this.exitLatch.await();
    }

    protected void finalize() throws InterruptedException {
        this.finish();
    }

    @Override
    public void run() {
        try {
            try {
                while (!this.finished.get()) {
                    Record record = this.publishQueue.poll(1L, TimeUnit.SECONDS);
                    if (record == null) continue;
                    this.internalAppender.publish(record);
                }
            }
            catch (InterruptedException interruptedException) {
                this.finished.set(true);
                LoggerManager.getLogger(AsynchronousAppender.class).error(interruptedException);
                this.exitLatch.countDown();
            }
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

