/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.File;
import org.smallmind.scribe.pen.FileSizeQuantifier;
import org.smallmind.scribe.pen.Rollover;
import org.smallmind.scribe.pen.Timestamp;

public class FileSizeRollover
extends Rollover {
    private FileSizeQuantifier fileSizeQuantifier;
    private long maxSize;

    public FileSizeRollover() {
        this(10L, FileSizeQuantifier.MEGABYTES);
    }

    public FileSizeRollover(long maxSize, FileSizeQuantifier fileSizeQuantifier) {
        this.maxSize = maxSize;
        this.fileSizeQuantifier = fileSizeQuantifier;
    }

    public FileSizeRollover(long maxSize, FileSizeQuantifier fileSizeQuantifier, char separator, Timestamp timestamp) {
        super(separator, timestamp);
        this.maxSize = maxSize;
        this.fileSizeQuantifier = fileSizeQuantifier;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public FileSizeQuantifier getFileSizeQuantifier() {
        return this.fileSizeQuantifier;
    }

    public void setFileSizeQuantifier(FileSizeQuantifier fileSizeQuantifier) {
        this.fileSizeQuantifier = fileSizeQuantifier;
    }

    @Override
    public boolean willRollover(File logFile, long bytesToBeWritten) {
        return logFile.length() + bytesToBeWritten > this.maxSize * (long)this.fileSizeQuantifier.getMultiplier();
    }
}

