/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.Arrays;
import java.util.LinkedList;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.Enhancer;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.LoggerManager;

public abstract class Template {
    public static final int NO_MATCH = -1;
    private LinkedList<Filter> filterList;
    private LinkedList<Appender> appenderList;
    private LinkedList<Enhancer> enhancerList;
    private Level level = Level.INFO;
    private boolean autoFillLogicalContext = false;
    private boolean registered = false;

    public Template() {
        this.filterList = new LinkedList();
        this.appenderList = new LinkedList();
        this.enhancerList = new LinkedList();
    }

    public Template(Level level, boolean autoFillLogicalContext) {
        this();
        this.level = level;
        this.autoFillLogicalContext = autoFillLogicalContext;
    }

    public Template(Filter[] filters, Appender[] appenders, Enhancer[] enhancers, Level level, boolean autoFillLogicalContext) {
        this();
        this.filterList.addAll(Arrays.asList(filters));
        this.appenderList.addAll(Arrays.asList(appenders));
        this.enhancerList.addAll(Arrays.asList(enhancers));
        this.level = level;
        this.autoFillLogicalContext = autoFillLogicalContext;
    }

    public abstract int matchLogger(String var1);

    public synchronized void register() {
        LoggerManager.addTemplate(this);
        this.registered = true;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized void setLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("Can't set a 'null' default level");
        }
        this.level = level;
        if (this.registered) {
            LoggerManager.commitTemplateChanges(Change.LEVEL, this);
        }
    }

    public synchronized boolean isAutoFillLogicalContext() {
        return this.autoFillLogicalContext;
    }

    public synchronized void setAutoFillLogicalContext(boolean autoFillLogicalContext) {
        this.autoFillLogicalContext = autoFillLogicalContext;
        if (this.registered) {
            LoggerManager.commitTemplateChanges(Change.CONTEXT, this);
        }
    }

    public void setFilter(Filter filter) {
        this.setFilters(new Filter[]{filter});
    }

    public synchronized void setFilters(Filter[] filters) {
        this.filterList.clear();
        this.filterList.addAll(Arrays.asList(filters));
        if (this.registered) {
            LoggerManager.commitTemplateChanges(Change.FILTER, this);
        }
    }

    public synchronized Filter[] getFilters() {
        Filter[] filters = new Filter[this.filterList.size()];
        this.filterList.toArray(filters);
        return filters;
    }

    public synchronized void addFilter(Filter filter) {
        this.filterList.add(filter);
        if (this.registered) {
            LoggerManager.commitTemplateChanges(Change.FILTER, this);
        }
    }

    public synchronized void removeFilter(Filter filter) {
        if (this.filterList.remove(filter) && this.registered) {
            LoggerManager.commitTemplateChanges(Change.FILTER, this);
        }
    }

    public void setAppender(Appender appender) {
        this.setAppenders(new Appender[]{appender});
    }

    public synchronized void setAppenders(Appender[] appenders) {
        this.appenderList.clear();
        this.appenderList.addAll(Arrays.asList(appenders));
        if (this.registered) {
            LoggerManager.commitTemplateChanges(Change.APPENDER, this);
        }
    }

    public synchronized Appender[] getAppenders() {
        Appender[] appenders = new Appender[this.appenderList.size()];
        this.appenderList.toArray(appenders);
        return appenders;
    }

    public synchronized void addAppender(Appender appender) {
        this.appenderList.add(appender);
        if (this.registered) {
            LoggerManager.commitTemplateChanges(Change.APPENDER, this);
        }
    }

    public synchronized void removeAppender(Appender appender) {
        if (this.appenderList.remove(appender) && this.registered) {
            LoggerManager.commitTemplateChanges(Change.APPENDER, this);
        }
    }

    public void setEnhancer(Enhancer enhancer) {
        this.setEnhancers(new Enhancer[]{enhancer});
    }

    public synchronized void setEnhancers(Enhancer[] enhancers) {
        this.enhancerList.clear();
        this.enhancerList.addAll(Arrays.asList(enhancers));
        if (this.registered) {
            LoggerManager.commitTemplateChanges(Change.ENHANCER, this);
        }
    }

    public synchronized Enhancer[] getEnhancers() {
        Enhancer[] enhancers = new Enhancer[this.enhancerList.size()];
        this.enhancerList.toArray(enhancers);
        return enhancers;
    }

    public synchronized void addEnhancer(Enhancer enhancer) {
        this.enhancerList.add(enhancer);
        if (this.registered) {
            LoggerManager.commitTemplateChanges(Change.ENHANCER, this);
        }
    }

    public synchronized void removeEnhancer(Enhancer enhancer) {
        if (this.enhancerList.remove(enhancer) && this.registered) {
            LoggerManager.commitTemplateChanges(Change.ENHANCER, this);
        }
    }

    protected synchronized void apply(Logger logger) {
        Change[] changeArray = Change.values();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change change = changeArray[n2];
            this.applyChange(change, logger);
            ++n2;
        }
    }

    protected synchronized void applyChange(Change change, Logger logger) {
        switch (change) {
            case LEVEL: {
                logger.setLevel(this.level);
                break;
            }
            case CONTEXT: {
                logger.setAutoFillLogicalContext(this.autoFillLogicalContext);
                break;
            }
            case FILTER: {
                logger.clearFilters();
                for (Filter filter : this.filterList) {
                    logger.addFilter(filter);
                }
                break;
            }
            case APPENDER: {
                logger.clearAppenders();
                for (Appender appender : this.appenderList) {
                    logger.addAppender(appender);
                }
                break;
            }
            case ENHANCER: {
                logger.clearEnhancers();
                for (Enhancer enhancer : this.enhancerList) {
                    logger.addEnhancer(enhancer);
                }
                break;
            }
            default: {
                throw new UnknownSwitchCaseException(change.name(), new Object[0]);
            }
        }
    }

    public static enum Change {
        LEVEL,
        CONTEXT,
        FILTER,
        APPENDER,
        ENHANCER;

    }
}

