/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen.aop;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.smallmind.scribe.pen.Discriminator;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.scribe.pen.aop.AutoLog;
import org.smallmind.scribe.pen.aop.AutoLogRuntimeException;
import org.smallmind.scribe.pen.aop.Unused;
import org.smallmind.scribe.pen.probe.Probe;
import org.smallmind.scribe.pen.probe.ProbeFactory;

@Aspect
public class LoggingAspect {
    private static final Class[] PARSE_SIGNATURE = new Class[]{String.class};
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ LoggingAspect ajc$perSingletonInstance;

    static {
        try {
            LoggingAspect.ajc$perSingletonInstance = new LoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private void startProbe(AutoLog autoLog, Class toBeLoggedClass) {
        Discriminator discriminator = null;
        if (!autoLog.discriminator().ofClass().equals(Unused.class)) {
            try {
                Method parseMethod = autoLog.discriminator().ofClass().getMethod("parse", PARSE_SIGNATURE);
                discriminator = (Discriminator)parseMethod.invoke(null, autoLog.discriminator().value());
            }
            catch (Exception exception) {
                throw new AutoLogRuntimeException(exception);
            }
        }
        Logger backingLogger = LoggerManager.getLogger(autoLog.name().equals("") ? toBeLoggedClass.getCanonicalName() : autoLog.name());
        Probe autoProbe = ProbeFactory.createProbe(backingLogger, discriminator, autoLog.off() ? Level.OFF : (!autoLog.level().equals((Object)Level.OFF) ? autoLog.level() : backingLogger.getLevel()), autoLog.title().length() == 0 ? null : autoLog.title());
        autoProbe.start();
    }

    private void stopProbe() {
        Probe probe = ProbeFactory.getProbe();
        if (probe == null) {
            throw new AutoLogRuntimeException("The current thread has no stored Probe", new Object[0]);
        }
        if (!probe.isAborted()) {
            probe.stop();
        }
    }

    private void abortProbe(Throwable throwable) {
        Probe probe = ProbeFactory.getProbe();
        if (probe == null) {
            throw new AutoLogRuntimeException("The current thread has no stored Probe", new Object[0]);
        }
        if (throwable.equals(ProbeFactory.getThrowable())) {
            probe.abort();
        } else {
            ProbeFactory.setThrowable(throwable);
            probe.abort(throwable);
        }
    }

    @Before(value="@within(autoLog) && (execution(* * (..)) || initialization(new(..)) || staticinitialization(*)) && !@annotation(AutoLog)", argNames="staticPart, autoLog")
    public void beforeClassToBeLogged(JoinPoint.StaticPart staticPart, AutoLog autoLog) {
        this.startProbe(autoLog, staticPart.getSourceLocation().getWithinType());
    }

    @Before(value="(execution(@AutoLog * * (..)) || initialization(@AutoLog new(..))) && @annotation(autoLog)", argNames="staticPart, autoLog")
    public void beforeMethodToBeLogged(JoinPoint.StaticPart staticPart, AutoLog autoLog) {
        this.startProbe(autoLog, staticPart.getSourceLocation().getWithinType());
    }

    @AfterReturning(value="@within(AutoLog) && (execution(* * (..)) || initialization(new(..)) || staticinitialization(*)) && !@annotation(AutoLog)")
    public void afterReturnFromClassToBeLogged() {
        this.stopProbe();
    }

    @AfterReturning(value="(execution(@AutoLog * * (..)) || initialization(@AutoLog new(..))) && @annotation(AutoLog)")
    public void afterReturnFromMethodToBeLogged() {
        this.stopProbe();
    }

    @AfterThrowing(pointcut="@within(AutoLog) && (execution(* * (..)) || initialization(new(..)) || staticinitialization(*))  && !@annotation(AutoLog)", throwing="throwable", argNames="throwable")
    public void afterThrowFromClassToBeLogged(Throwable throwable) {
        this.abortProbe(throwable);
    }

    @AfterThrowing(pointcut="(execution(@AutoLog * * (..)) || initialization(@AutoLog new(..))) && @annotation(AutoLog)", throwing="throwable", argNames="throwable")
    public void afterThrowFromMethodToBeLogged(Throwable throwable) {
        this.abortProbe(throwable);
    }

    public static LoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.smallmind.scribe.pen.aop.LoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

