/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen.probe;

import org.smallmind.scribe.pen.Discriminator;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.probe.Instrument;
import org.smallmind.scribe.pen.probe.InstrumentAndReturn;
import org.smallmind.scribe.pen.probe.Probe;
import org.smallmind.scribe.pen.probe.ProbeException;
import org.smallmind.scribe.pen.probe.ProbeStack;

public class ProbeFactory {
    private static final ProbeStackThreadLocal PROBE_STACK_LOCAL = new ProbeStackThreadLocal();
    private static final ThreadLocal<Throwable> THROWABLE_LOCAL = new ThreadLocal();
    private static final ThreadLocal<byte[]> IDENTIFIER_LOCAL = new ThreadLocal();

    public static void setIdentifier(byte[] identifier) {
        IDENTIFIER_LOCAL.set(identifier);
    }

    public static byte[] getIdentifier() {
        return IDENTIFIER_LOCAL.get();
    }

    public static void setThrowable(Throwable throwable) {
        THROWABLE_LOCAL.set(throwable);
    }

    public static Throwable getThrowable() {
        return THROWABLE_LOCAL.get();
    }

    public static Probe getProbe() {
        return ((ProbeStack)PROBE_STACK_LOCAL.get()).peek();
    }

    public static Probe createProbe(Logger logger, Discriminator discriminator, Level level, String title) {
        return ((ProbeStack)PROBE_STACK_LOCAL.get()).push(logger, discriminator, level, title);
    }

    protected static void closeProbe(Probe probe) throws ProbeException {
        ((ProbeStack)PROBE_STACK_LOCAL.get()).pop(probe);
    }

    public static void executeInstrumentation(Logger logger, Discriminator discriminator, Level level, String title, Instrument instrument) throws ProbeException {
        Probe probe = ProbeFactory.createProbe(logger, discriminator, level, title);
        probe.start();
        try {
            try {
                instrument.withProbe(probe);
            }
            catch (ProbeException probeException) {
                probe.abort();
                throw probeException;
            }
            catch (Exception exception) {
                probe.abort(exception);
                throw new ProbeException(exception);
            }
        }
        finally {
            if (!probe.isAborted()) {
                probe.stop();
            }
        }
    }

    public static <T> T executeInstrumentationAndReturn(Logger logger, Discriminator discriminator, Level level, String title, InstrumentAndReturn<T> instrumentAndReturn) throws ProbeException {
        Probe probe = ProbeFactory.createProbe(logger, discriminator, level, title);
        probe.start();
        try {
            T t = instrumentAndReturn.withProbe(probe);
            return t;
        }
        catch (ProbeException probeException) {
            probe.abort();
            throw probeException;
        }
        catch (Exception exception) {
            probe.abort(exception);
            throw new ProbeException(exception);
        }
        finally {
            if (!probe.isAborted()) {
                probe.stop();
            }
        }
    }

    private static class ProbeStackThreadLocal
    extends InheritableThreadLocal<ProbeStack> {
        private ProbeStackThreadLocal() {
        }

        @Override
        protected ProbeStack initialValue() {
            return new ProbeStack(ProbeFactory.getIdentifier());
        }

        @Override
        protected ProbeStack childValue(ProbeStack parentValue) {
            return new ProbeStack(parentValue.getCurrentIdentifier());
        }
    }
}

