/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen.probe;

import java.util.LinkedList;
import org.smallmind.nutsnbolts.util.UniqueId;
import org.smallmind.scribe.pen.Discriminator;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.probe.Correlator;
import org.smallmind.scribe.pen.probe.Probe;
import org.smallmind.scribe.pen.probe.ProbeException;

public class ProbeStack {
    private LinkedList<Probe> probeList;
    private byte[] threadIdentifier;
    private byte[] parentIdentifier;
    private int instance = 0;

    public ProbeStack(byte[] parentIdentifier) {
        this.parentIdentifier = parentIdentifier;
        this.threadIdentifier = UniqueId.newInstance().asByteArray();
        this.probeList = new LinkedList();
    }

    public byte[] getCurrentIdentifier() {
        if (this.probeList.isEmpty()) {
            return null;
        }
        return this.probeList.getFirst().getCorrelator().getIdentifier();
    }

    public Probe peek() {
        if (this.probeList.isEmpty()) {
            return null;
        }
        return this.probeList.getFirst();
    }

    public Probe push(Logger logger, Discriminator discriminator, Level level, String title) {
        Probe probe = new Probe(logger, discriminator, level, new Correlator(this.threadIdentifier, this.probeList.isEmpty() ? this.parentIdentifier : this.probeList.getFirst().getCorrelator().getIdentifier(), UniqueId.newInstance().asByteArray(), this.probeList.size(), this.instance++), title, this.probeList.isEmpty());
        this.probeList.addFirst(probe);
        return probe;
    }

    public void pop(Probe probe) throws ProbeException {
        if (!probe.equals(this.probeList.getFirst())) {
            throw new ProbeException("Out of order Probe(%s) termination", new Object[]{probe.getCorrelator().getIdentifier()});
        }
        this.probeList.removeFirst();
    }
}

