/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import org.smallmind.scribe.pen.FileSizeQuantifier;
import org.smallmind.scribe.pen.RolloverRule;

public class FileSizeRolloverRule
implements RolloverRule {
    private FileSizeQuantifier fileSizeQuantifier;
    private long maxSize;

    public FileSizeRolloverRule() {
        this(10L, FileSizeQuantifier.MEGABYTES);
    }

    public FileSizeRolloverRule(long maxSize, FileSizeQuantifier fileSizeQuantifier) {
        this.maxSize = maxSize;
        this.fileSizeQuantifier = fileSizeQuantifier;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public FileSizeQuantifier getFileSizeQuantifier() {
        return this.fileSizeQuantifier;
    }

    public void setFileSizeQuantifier(FileSizeQuantifier fileSizeQuantifier) {
        this.fileSizeQuantifier = fileSizeQuantifier;
    }

    @Override
    public boolean willRollover(long fileSize, long lastModified, long bytesToBeWritten) {
        return fileSize + bytesToBeWritten > this.maxSize * (long)this.fileSizeQuantifier.getMultiplier();
    }
}

