/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.smallmind.nutsnbolts.time.Duration;
import org.smallmind.scribe.pen.CleanupRule;

public class LastModifiedCleanupRule
implements CleanupRule<LastModifiedCleanupRule> {
    private Duration duration;
    private long durationAsMilliseconds;
    private long now = System.currentTimeMillis();

    public LastModifiedCleanupRule() {
    }

    public LastModifiedCleanupRule(Duration duration) {
        this.setDuration(duration);
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
        this.durationAsMilliseconds = duration.toMilliseconds();
    }

    @Override
    public LastModifiedCleanupRule copy() {
        return new LastModifiedCleanupRule(this.duration);
    }

    @Override
    public boolean willCleanup(Path possiblePath) throws IOException {
        return this.now - Files.getLastModifiedTime(possiblePath, new LinkOption[0]).toMillis() > this.durationAsMilliseconds;
    }

    @Override
    public void finish() {
    }
}

