/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.Template;

public class LoggerManager {
    private static final HashMap<String, Logger> LOGGER_MAP = new HashMap();
    private static final HashMap<Logger, Template> TEMPLATE_MAP = new HashMap();
    private static final HashSet<Template> TEMPLATE_SET = new HashSet();
    private static final CopyOnWriteArraySet<String> LOGGING_PACKAGE_PREFIX_QUEUE = new CopyOnWriteArraySet();

    static {
        LOGGING_PACKAGE_PREFIX_QUEUE.add("org.smallmind.scribe.");
    }

    public static void addLoggingPackagePrefix(String packageName) {
        LOGGING_PACKAGE_PREFIX_QUEUE.add(packageName);
    }

    public static boolean isLoggingClass(String className) {
        for (String packagePrefix : LOGGING_PACKAGE_PREFIX_QUEUE) {
            if (!className.startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTemplate(Template template) {
        Class<LoggerManager> clazz = LoggerManager.class;
        synchronized (LoggerManager.class) {
            if (!TEMPLATE_SET.contains(template)) {
                TEMPLATE_SET.add(template);
                LoggerManager.reAssociateAllLoggers();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTemplate(Template template) {
        Class<LoggerManager> clazz = LoggerManager.class;
        synchronized (LoggerManager.class) {
            if (TEMPLATE_SET.remove(template)) {
                LoggerManager.reAssociateAllLoggers();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Template getTemplate(Logger logger) {
        Class<LoggerManager> clazz = LoggerManager.class;
        synchronized (LoggerManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return TEMPLATE_MAP.get(logger);
        }
    }

    public static Logger getLogger(Class loggableClass) {
        return LoggerManager.getLogger(loggableClass.getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger getLogger(String name) {
        Logger logger = LOGGER_MAP.get(name);
        if (logger != null) return logger;
        Class<LoggerManager> clazz = LoggerManager.class;
        synchronized (LoggerManager.class) {
            logger = LOGGER_MAP.get(name);
            if (logger != null) return logger;
            logger = new Logger(name);
            LOGGER_MAP.put(name, logger);
            LoggerManager.associateTemplate(logger);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void commitTemplateChanges(Template.Change change, Template template) {
        Class<LoggerManager> clazz = LoggerManager.class;
        synchronized (LoggerManager.class) {
            for (Logger logger : TEMPLATE_MAP.keySet()) {
                if (!TEMPLATE_MAP.get(logger).equals(template)) continue;
                template.applyChange(change, logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void reAssociateAllLoggers() {
        for (Logger logger : LOGGER_MAP.values()) {
            LoggerManager.associateTemplate(logger);
        }
    }

    private static void associateTemplate(Logger logger) {
        Object matchingTemplate = null;
        int matchingPriority = -1;
        for (Template template : TEMPLATE_SET) {
            int templatePriority = template.matchLogger(logger.getName());
            if (templatePriority <= matchingPriority) continue;
            matchingTemplate = template;
            matchingPriority = templatePriority;
        }
        if (matchingTemplate == null) {
            TEMPLATE_MAP.remove(logger);
        } else if (!matchingTemplate.equals(LoggerManager.getTemplate(logger))) {
            ((Template)matchingTemplate).apply(logger);
            TEMPLATE_MAP.put(logger, (Template)matchingTemplate);
        }
    }
}

