/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.ConsoleAppender;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.XMLFormatter;
import org.smallmind.scribe.pen.adapter.LoggingBlueprintFactory;

public class DefaultErrorHandler
implements ErrorHandler {
    private Appender appender;

    public DefaultErrorHandler() {
        this.appender = new ConsoleAppender(new XMLFormatter());
    }

    public DefaultErrorHandler(Appender appender) {
        this.setBackupAppender(appender);
    }

    @Override
    public void setBackupAppender(Appender appender) {
        this.appender = appender;
    }

    @Override
    public void process(Record record, Exception exception, String errorMessage, Object ... args) {
        this.appender.publish(LoggingBlueprintFactory.getLoggingBlueprint().errorRecord(record, exception, errorMessage, args));
        this.appender.publish(record);
    }
}

