/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.List;
import org.smallmind.nutsnbolts.util.SnowflakeId;
import org.smallmind.scribe.pen.AbstractAppender;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LoggerRuntimeException;
import org.smallmind.scribe.pen.Record;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.RejectedLogEventsInfo;

public class AWSAppender
extends AbstractAppender {
    private final CloudWatchLogsClient client;
    private final Formatter formatter;
    private final String groupName;
    private final String streamName;
    private String sequenceToken;

    public AWSAppender(Formatter formatter, ErrorHandler errorHandler, CloudWatchLogsClient client, String groupName, String streamName) {
        super(errorHandler);
        List describedLogStreamList;
        this.formatter = formatter;
        this.client = client;
        this.groupName = groupName;
        this.streamName = streamName;
        if (streamName == null) {
            streamName = SnowflakeId.newInstance().generateHexEncoding();
            client.createLogStream((CreateLogStreamRequest)CreateLogStreamRequest.builder().logGroupName(groupName).logStreamName(streamName).build());
        }
        if ((describedLogStreamList = client.describeLogStreams((DescribeLogStreamsRequest)DescribeLogStreamsRequest.builder().logGroupName(groupName).logStreamNamePrefix(streamName).build()).logStreams()) == null || describedLogStreamList.isEmpty()) {
            throw new LoggerRuntimeException("The log stream(groupName=%s, streamName=%s) does not exist", groupName, streamName);
        }
        if (describedLogStreamList.size() > 1) {
            throw new LoggerRuntimeException("The log stream(groupName=%s, streamName=%s) is not unique", groupName, streamName);
        }
        this.sequenceToken = ((LogStream)describedLogStreamList.get(0)).uploadSequenceToken();
    }

    @Override
    public synchronized void handleOutput(Record<?> record) throws Exception {
        InputLogEvent inputLogEvent = (InputLogEvent)InputLogEvent.builder().message(this.formatter.format(record)).timestamp(Long.valueOf(record.getMillis())).build();
        PutLogEventsRequest putLogEventsRequest = (PutLogEventsRequest)PutLogEventsRequest.builder().logGroupName(this.groupName).logStreamName(this.streamName).sequenceToken(this.sequenceToken).logEvents(new InputLogEvent[]{inputLogEvent}).build();
        PutLogEventsResponse putLogEventsResponse = this.client.putLogEvents(putLogEventsRequest);
        RejectedLogEventsInfo rejectedLogEventsInfo = putLogEventsResponse.rejectedLogEventsInfo();
        if (rejectedLogEventsInfo != null) {
            if (rejectedLogEventsInfo.expiredLogEventEndIndex() != null) {
                throw new LoggerRuntimeException("Log entry(%s) has expired", this.sequenceToken);
            }
            if (rejectedLogEventsInfo.tooNewLogEventStartIndex() != null) {
                throw new LoggerRuntimeException("Log entry(%s) is too new", this.sequenceToken);
            }
            if (rejectedLogEventsInfo.tooOldLogEventEndIndex() != null) {
                throw new LoggerRuntimeException("Log entry(%s) is too old", this.sequenceToken);
            }
        } else {
            this.sequenceToken = putLogEventsResponse.nextSequenceToken();
        }
    }
}

