/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.Record;

public abstract class AbstractAppender
implements Appender {
    private final ConcurrentLinkedQueue<Filter> filterList;
    private ErrorHandler errorHandler;
    private String name;
    private boolean active = true;

    public AbstractAppender() {
        this(null, null);
    }

    public AbstractAppender(ErrorHandler errorHandler) {
        this(null, errorHandler);
    }

    public AbstractAppender(String name, ErrorHandler errorHandler) {
        this.name = name;
        this.errorHandler = errorHandler;
        this.filterList = new ConcurrentLinkedQueue();
    }

    public abstract void handleOutput(Record<?> var1) throws Exception;

    public void handleError(ErrorHandler errorHandler, Record<?> record, Exception exception) {
        errorHandler.process(record, exception, "Fatal error in appender(%s)", this.getClass().getCanonicalName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized void clearFilters() {
        this.filterList.clear();
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.filterList.clear();
        this.filterList.add(filter);
    }

    @Override
    public synchronized void addFilter(Filter filter) {
        this.filterList.add(filter);
    }

    @Override
    public synchronized Filter[] getFilters() {
        Filter[] filters = new Filter[this.filterList.size()];
        this.filterList.toArray(filters);
        return filters;
    }

    @Override
    public synchronized void setFilters(List<Filter> replacementFilterList) {
        this.filterList.clear();
        this.filterList.addAll(replacementFilterList);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void publish(Record<?> record) {
        try {
            for (Filter filter : this.filterList) {
                if (filter.willLog(record)) continue;
                return;
            }
            this.handleOutput(record);
        }
        catch (Exception exception) {
            if (this.errorHandler == null) {
                exception.printStackTrace();
            }
            this.handleError(this.errorHandler, record, exception);
        }
    }

    @Override
    public void close() throws LoggerException {
    }
}

