/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import org.smallmind.scribe.pen.AbstractAppender;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.FormattedAppender;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.Record;

public abstract class AbstractFormattedAppender
extends AbstractAppender
implements FormattedAppender {
    private Formatter formatter;

    public AbstractFormattedAppender() {
    }

    public AbstractFormattedAppender(Formatter formatter, ErrorHandler errorHandler) {
        super(errorHandler);
        this.formatter = formatter;
    }

    public AbstractFormattedAppender(String name, Formatter formatter, ErrorHandler errorHandler) {
        super(name, errorHandler);
        this.formatter = formatter;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public abstract void handleOutput(String var1) throws Exception;

    @Override
    public void handleOutput(Record<?> record) throws Exception {
        if (this.formatter == null) {
            throw new LoggerException("No formatter set for log output on this appender(%s)", this.getClass().getCanonicalName());
        }
        this.handleOutput(this.formatter.format(record));
    }
}

