/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.scribe.pen.AbstractWrappedAppender;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.scribe.pen.Record;

public class AsynchronousAppender
extends AbstractWrappedAppender {
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final LinkedBlockingQueue<Record<?>> publishQueue;
    private final PublishWorker publishWorker;
    private final int bufferSize;

    public AsynchronousAppender(Appender internalAppender) {
        this(internalAppender, Integer.MAX_VALUE);
    }

    public AsynchronousAppender(Appender internalAppender, int bufferSize) {
        super(internalAppender);
        this.bufferSize = bufferSize;
        this.publishQueue = new LinkedBlockingQueue(bufferSize);
        this.publishWorker = new PublishWorker();
        Thread publishThread = new Thread(this.publishWorker);
        publishThread.setDaemon(true);
        publishThread.start();
    }

    @Override
    public void publish(Record<?> record) {
        try {
            if (this.finished.get()) {
                throw new LoggerException("%s has been previously closed", this.getClass().getSimpleName());
            }
            if (!this.publishQueue.offer(record)) {
                throw new LoggerException("Buffer exceeded(%d) on %s", this.bufferSize, AsynchronousAppender.class.getSimpleName());
            }
        }
        catch (Exception exception) {
            if (this.getErrorHandler() == null) {
                exception.printStackTrace();
            }
            this.getErrorHandler().process(record, exception, "Unable to publish message from appender(%s)", this.getName() != null ? this.getName() : this.getClass().getCanonicalName());
        }
    }

    @Override
    public void close() throws InterruptedException, LoggerException {
        this.publishWorker.finish();
        super.close();
    }

    private class PublishWorker
    implements Runnable {
        private final CountDownLatch exitLatch = new CountDownLatch(1);
        private Thread runnableThread;

        private PublishWorker() {
        }

        private void finish() throws InterruptedException {
            if (AsynchronousAppender.this.finished.compareAndSet(false, true)) {
                this.runnableThread.interrupt();
            }
            this.exitLatch.await();
        }

        @Override
        public void run() {
            try {
                this.runnableThread = Thread.currentThread();
                while (!AsynchronousAppender.this.finished.get()) {
                    try {
                        Record<?> record = AsynchronousAppender.this.publishQueue.poll(1L, TimeUnit.SECONDS);
                        if (record == null) continue;
                        AsynchronousAppender.this.publishToWrappedAppender(record);
                    }
                    catch (InterruptedException interruptedException) {
                        AsynchronousAppender.this.finished.set(true);
                    }
                    catch (Exception exception) {
                        LoggerManager.getLogger(AsynchronousAppender.class).error(exception);
                    }
                }
            }
            finally {
                this.exitLatch.countDown();
            }
        }
    }
}

