/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;

public class CloudWatchLogsClientFactory
implements FactoryBean<CloudWatchLogsClient>,
InitializingBean {
    private CloudWatchLogsClient client;
    private Region region;
    private String awsAccessKey;
    private String awsSecretKey;

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return CloudWatchLogsClient.class;
    }

    public CloudWatchLogsClient getObject() {
        return this.client;
    }

    public void afterPropertiesSet() throws Exception {
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.awsAccessKey, (String)this.awsSecretKey));
        this.client = (CloudWatchLogsClient)((CloudWatchLogsClientBuilder)((CloudWatchLogsClientBuilder)CloudWatchLogsClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(this.region)).build();
    }
}

