/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.Date;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.LoggerContext;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.PatternRule;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.Timestamp;

public class ConversionPatternRule
implements PatternRule {
    private final String header;
    private final String footer;
    private final String multiLinePrefix;
    private final Padding padding;
    private final boolean prefixFirstLine;
    private final char conversion;
    private final int width;
    private final int precision;

    public ConversionPatternRule(String header, String paddingString, String widthString, String precisionString, String firstLineString, String multiLinePrefix, String conversionString, String footer) {
        this(header, paddingString == null ? Padding.NONE : (paddingString.equals("+") ? Padding.RIGHT : Padding.LEFT), widthString == null ? -1 : Integer.parseInt(widthString), precisionString == null ? -1 : Integer.parseInt(precisionString), !"-".equals(firstLineString), multiLinePrefix == null ? String.valueOf(System.getProperty("line.separator")) + '\t' : multiLinePrefix, conversionString.charAt(0), footer);
    }

    public ConversionPatternRule(String header, Padding padding, int width, int precision, boolean prefixFirstLine, String multiLinePrefix, char conversion, String footer) {
        this.header = this.stripSlashes(header);
        this.padding = padding;
        this.width = width;
        this.precision = precision;
        this.prefixFirstLine = prefixFirstLine;
        this.multiLinePrefix = this.stripSlashes(multiLinePrefix);
        this.conversion = conversion;
        this.footer = this.stripSlashes(footer);
    }

    private static int findRepeatedStackElements(StackTraceElement singleElement, StackTraceElement[] prevStackTrace) {
        int count = 0;
        while (count < prevStackTrace.length) {
            if (singleElement.equals(prevStackTrace[count])) {
                return prevStackTrace.length - count;
            }
            ++count;
        }
        return -1;
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public String getFooter() {
        return this.footer;
    }

    private String stripSlashes(String slashedString) {
        if (slashedString == null) {
            return null;
        }
        boolean slashed = false;
        StringBuffer strippedBuffer = new StringBuffer();
        int count = 0;
        while (count < slashedString.length()) {
            if (slashed) {
                switch (slashedString.charAt(count)) {
                    case 'r': {
                        strippedBuffer.append('\r');
                        break;
                    }
                    case 't': {
                        strippedBuffer.append('\t');
                        break;
                    }
                    case 'f': {
                        strippedBuffer.append('\f');
                        break;
                    }
                    case 'n': {
                        strippedBuffer.append(System.getProperty("line.separator"));
                        break;
                    }
                    default: {
                        strippedBuffer.append(slashedString.charAt(count));
                    }
                }
                slashed = false;
            } else if (slashedString.charAt(count) == '\\') {
                slashed = true;
            } else {
                strippedBuffer.append(slashedString.charAt(count));
            }
            ++count;
        }
        if (slashed) {
            strippedBuffer.append('\\');
        }
        return strippedBuffer.toString();
    }

    @Override
    public String convert(Record<?> record, Timestamp timestamp) {
        Throwable throwable = record.getThrown();
        switch (this.conversion) {
            case 'd': {
                return this.trimToWidthAndPad(timestamp.getTimestamp(new Date(record.getMillis())));
            }
            case 't': {
                return this.trimToWidthAndPad(String.valueOf(record.getMillis()));
            }
            case 'n': {
                return this.trimToWidthAndPad(this.trimToDotPrecision(record.getLoggerName()));
            }
            case 'l': {
                return this.trimToWidthAndPad(record.getLevel().name());
            }
            case 'm': {
                String message = record.getMessage();
                if (message == null && throwable != null) {
                    message = throwable.getMessage();
                }
                return this.trimToWidthAndPad(message);
            }
            case 'T': {
                return this.trimToWidthAndPad(record.getThreadName());
            }
            case 'C': {
                LoggerContext loggerContext = record.getLoggerContext();
                if (loggerContext != null && loggerContext.isFilled()) {
                    return this.trimToWidthAndPad(this.trimToDotPrecision(loggerContext.getClassName()));
                }
                return null;
            }
            case 'M': {
                LoggerContext loggerContext = record.getLoggerContext();
                if (loggerContext != null && loggerContext.isFilled()) {
                    return this.trimToWidthAndPad(loggerContext.getMethodName());
                }
                return null;
            }
            case 'N': {
                LoggerContext loggerContext = record.getLoggerContext();
                if (loggerContext != null && loggerContext.isFilled()) {
                    return this.trimToWidthAndPad(String.valueOf(loggerContext.isNativeMethod()));
                }
                return null;
            }
            case 'L': {
                LoggerContext loggerContext = record.getLoggerContext();
                if (loggerContext != null && loggerContext.isFilled()) {
                    return this.trimToWidthAndPad(String.valueOf(loggerContext.getLineNumber()));
                }
                return null;
            }
            case 'F': {
                LoggerContext loggerContext = record.getLoggerContext();
                if (loggerContext != null && loggerContext.isFilled()) {
                    return this.trimToWidthAndPad(loggerContext.getFileName());
                }
                return null;
            }
            case 's': {
                if (throwable != null) {
                    StringBuilder stackBuilder = new StringBuilder();
                    StackTraceElement[] prevStackTrace = null;
                    if (this.prefixFirstLine && this.multiLinePrefix != null) {
                        stackBuilder.append(this.multiLinePrefix);
                    }
                    do {
                        if (prevStackTrace == null) {
                            stackBuilder.append("Exception in thread ");
                        } else {
                            if (this.prefixFirstLine && this.multiLinePrefix != null) {
                                stackBuilder.append(this.multiLinePrefix);
                            }
                            stackBuilder.append("Caused by: ");
                        }
                        stackBuilder.append(throwable.getClass().getCanonicalName());
                        stackBuilder.append(": ");
                        stackBuilder.append(throwable.getMessage());
                        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                        int n = stackTraceElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int repeatedElements;
                            StackTraceElement singleElement = stackTraceElementArray[n2];
                            if (this.multiLinePrefix != null) {
                                stackBuilder.append(this.multiLinePrefix);
                            }
                            if (prevStackTrace != null && (repeatedElements = ConversionPatternRule.findRepeatedStackElements(singleElement, prevStackTrace)) >= 0) {
                                stackBuilder.append("   ... ");
                                stackBuilder.append(repeatedElements);
                                stackBuilder.append(" more");
                                break;
                            }
                            stackBuilder.append("   at ");
                            stackBuilder.append(singleElement.toString());
                            ++n2;
                        }
                        prevStackTrace = throwable.getStackTrace();
                    } while ((throwable = throwable.getCause()) != null);
                    return stackBuilder.toString();
                }
                return null;
            }
            case 'p': {
                Parameter[] parameters = record.getParameters();
                if (parameters.length > 0) {
                    StringBuilder parameterBuilder = new StringBuilder();
                    int parameterCount = 0;
                    Parameter[] parameterArray = parameters;
                    int n = parameters.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Parameter parameter = parameterArray[n3];
                        if (this.precision > 0 && ++parameterCount > this.precision) break;
                        if ((this.prefixFirstLine || parameterBuilder.length() > 0) && this.multiLinePrefix != null) {
                            parameterBuilder.append(this.multiLinePrefix);
                        }
                        parameterBuilder.append(parameter.getKey());
                        parameterBuilder.append('=');
                        parameterBuilder.append(parameter.getValue());
                        ++n3;
                    }
                    if (parameterBuilder.length() > 0) {
                        return parameterBuilder.toString();
                    }
                }
                return null;
            }
        }
        throw new UnknownSwitchCaseException("%c", new Object[]{Character.valueOf(this.conversion)});
    }

    private String trimToDotPrecision(String field) {
        String[] segments;
        if (field == null) {
            return null;
        }
        if (this.precision > 0 && (segments = field.split("\\.", -1)).length > this.precision) {
            StringBuilder segmentBuilder = new StringBuilder();
            int count = segments.length - this.precision;
            while (count < segments.length) {
                if (count > segments.length - this.precision) {
                    segmentBuilder.append('.');
                }
                segmentBuilder.append(segments[count]);
                ++count;
            }
            return segmentBuilder.toString();
        }
        return field;
    }

    private String trimToWidthAndPad(String field) {
        if (field == null) {
            return null;
        }
        if (field.length() < this.width) {
            switch (this.padding) {
                case NONE: {
                    return field;
                }
                case RIGHT: {
                    return field + " ".repeat(this.width - field.length());
                }
                case LEFT: {
                    return " ".repeat(this.width - field.length()) + field;
                }
            }
            throw new UnknownSwitchCaseException(this.padding.name(), new Object[0]);
        }
        if (this.width > 0) {
            return field.substring(0, this.width);
        }
        return field;
    }

    private static enum Padding {
        LEFT,
        RIGHT,
        NONE;

    }
}

