/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.scribe.pen.LoggerContext;
import org.smallmind.scribe.pen.LoggerManager;

public class DefaultLoggerContext
implements LoggerContext {
    private final AtomicBoolean filled = new AtomicBoolean(false);
    private StackTraceElement contextElement;

    private static boolean willPrime(String className) {
        return LoggerManager.isLoggingClass(className);
    }

    @Override
    public boolean isFilled() {
        return this.filled.get();
    }

    @Override
    public void fillIn() {
        this.setContextElement();
    }

    @Override
    public String getClassName() {
        this.setContextElement();
        return this.contextElement.getClassName();
    }

    @Override
    public String getMethodName() {
        this.setContextElement();
        return this.contextElement.getMethodName();
    }

    @Override
    public String getFileName() {
        this.setContextElement();
        return this.contextElement.getFileName();
    }

    @Override
    public boolean isNativeMethod() {
        this.setContextElement();
        return this.contextElement.isNativeMethod();
    }

    @Override
    public int getLineNumber() {
        this.setContextElement();
        return this.contextElement.getLineNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextElement() {
        if (!this.filled.get()) {
            DefaultLoggerContext defaultLoggerContext = this;
            synchronized (defaultLoggerContext) {
                if (!this.filled.get()) {
                    boolean primed = false;
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    int n = stackTraceElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement currentElement = stackTraceElementArray[n2];
                        if (primed) {
                            if (!DefaultLoggerContext.willPrime(currentElement.getClassName())) {
                                this.contextElement = currentElement;
                                break;
                            }
                        } else {
                            primed = DefaultLoggerContext.willPrime(currentElement.getClassName());
                        }
                        ++n2;
                    }
                    if (!primed || this.contextElement == null) {
                        throw new IllegalStateException("The logging call context was not found");
                    }
                    this.filled.set(true);
                }
            }
        }
    }
}

