/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.nutsnbolts.util.DotNotation;
import org.smallmind.nutsnbolts.util.DotNotationException;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.Record;

public class DotNotatedLoggerNameFilter
implements Filter {
    private final HashMap<String, DotNotation> patternMap = new HashMap();
    private final ConcurrentLinkedQueue<String> classList = new ConcurrentLinkedQueue();
    private final Lock patternReadLock;
    private final Lock patternWriteLock;
    private Level passThroughLevel;

    public DotNotatedLoggerNameFilter() throws LoggerException {
        this(Level.INFO, null);
    }

    public DotNotatedLoggerNameFilter(Level passThroughLevel) throws LoggerException {
        this(passThroughLevel, null);
    }

    public DotNotatedLoggerNameFilter(Level passThroughLevel, List<String> patterns) throws LoggerException {
        this.passThroughLevel = passThroughLevel;
        if (patterns != null) {
            this.setPatterns(patterns);
        }
        ReentrantReadWriteLock patternReadWriteLock = new ReentrantReadWriteLock();
        this.patternReadLock = patternReadWriteLock.readLock();
        this.patternWriteLock = patternReadWriteLock.writeLock();
    }

    public synchronized Level getPassThroughLevel() {
        return this.passThroughLevel;
    }

    public synchronized void setPassThroughLevel(Level passThroughLevel) {
        this.passThroughLevel = passThroughLevel;
    }

    public synchronized void setPatterns(List<String> patterns) throws LoggerException {
        this.patternMap.clear();
        for (String protoPattern : patterns) {
            try {
                this.patternMap.put(protoPattern, new DotNotation(protoPattern));
            }
            catch (DotNotationException dotNotationException) {
                throw new LoggerException(dotNotationException);
            }
        }
    }

    public boolean isClassNameOn(String className) {
        return className != null && (this.classList.contains(className) || this.noCachedMatch(className, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean noCachedMatch(String className, boolean addIfFound) {
        this.patternReadLock.lock();
        try {
            for (DotNotation notation : this.patternMap.values()) {
                if (!notation.getPattern().matcher(className).matches()) continue;
                if (addIfFound) {
                    ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.classList;
                    synchronized (concurrentLinkedQueue) {
                        if (!this.classList.contains(className)) {
                            this.classList.add(className);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        finally {
            this.patternReadLock.unlock();
        }
    }

    public void setDebugCategory(String protoPattern, boolean isOn) throws LoggerException {
        block7: {
            this.patternWriteLock.lock();
            try {
                if (isOn) {
                    if (this.patternMap.containsKey(protoPattern)) break block7;
                    try {
                        this.patternMap.put(protoPattern, new DotNotation(protoPattern));
                        break block7;
                    }
                    catch (DotNotationException dotNotationException) {
                        throw new LoggerException(dotNotationException);
                    }
                }
                if (this.patternMap.remove(protoPattern) != null) {
                    this.classList.removeIf(className -> !this.noCachedMatch((String)className, false));
                }
            }
            finally {
                this.patternWriteLock.unlock();
            }
        }
    }

    @Override
    public boolean willLog(Record<?> record) {
        return record.getLevel().atLeast(this.passThroughLevel) || this.isClassNameOn(record.getLoggerName());
    }
}

