/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import javax.activation.DataSource;
import org.smallmind.nutsnbolts.email.Authentication;
import org.smallmind.nutsnbolts.email.Mail;
import org.smallmind.nutsnbolts.email.Postman;
import org.smallmind.scribe.pen.AbstractFormattedAppender;

public class EmailAppender
extends AbstractFormattedAppender {
    private final Postman postman;
    private String from;
    private String to;
    private String subject;

    public EmailAppender(String smtpServer, int smtpPort) {
        this(smtpServer, smtpPort, Authentication.NONE, false);
    }

    public EmailAppender(String smtpServer, int smtpPort, Authentication authentication) {
        this(smtpServer, smtpPort, authentication, false);
    }

    public EmailAppender(String smtpServer, int smtpPort, boolean secure) {
        this(smtpServer, smtpPort, Authentication.NONE, secure);
    }

    public EmailAppender(String smtpServer, int smtpPort, Authentication authentication, boolean secure) {
        this.postman = new Postman(smtpServer, smtpPort, authentication, secure);
    }

    public EmailAppender(String smtpServer, int smtpPort, String from, String to, String subject) {
        this(smtpServer, smtpPort);
        this.from = from;
        this.to = to;
        this.subject = subject;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public void handleOutput(String output) throws Exception {
        this.postman.send(new Mail(this.from, this.to, this.subject, output, new DataSource[0]));
    }
}

