/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Record;

public class ExceptionSuppressingLogFilter
implements Filter {
    private static final HashSet<Class<? extends Throwable>> SUPPRESSED_THROWABLE_SET = new HashSet();
    private static final ReentrantReadWriteLock UPDATE_LOCK = new ReentrantReadWriteLock();

    public static void addSuppressedThrowableClasses(List<Class<? extends Throwable>> suppressedThrowableClasses) {
        if (suppressedThrowableClasses != null) {
            UPDATE_LOCK.writeLock().lock();
            try {
                SUPPRESSED_THROWABLE_SET.addAll(suppressedThrowableClasses);
            }
            finally {
                UPDATE_LOCK.writeLock().unlock();
            }
        }
    }

    @Override
    public boolean willLog(Record<?> record) {
        Throwable loggedThrowable = record.getThrown();
        if (loggedThrowable != null) {
            UPDATE_LOCK.readLock().lock();
            try {
                boolean bl = !SUPPRESSED_THROWABLE_SET.contains(loggedThrowable.getClass());
                return bl;
            }
            finally {
                UPDATE_LOCK.readLock().unlock();
            }
        }
        return true;
    }
}

