/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.smallmind.scribe.pen.CleanupRule;

public class FileCountCleanupRule
implements CleanupRule<FileCountCleanupRule> {
    private final LinkedList<Path> pathList = new LinkedList();
    private int maximum;

    public FileCountCleanupRule() {
    }

    public FileCountCleanupRule(int maximum) {
        this.maximum = maximum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    @Override
    public FileCountCleanupRule copy() {
        return new FileCountCleanupRule(this.maximum);
    }

    @Override
    public boolean willCleanup(Path possiblePath) {
        this.pathList.add(possiblePath);
        return false;
    }

    @Override
    public void finish() throws IOException {
        if (this.pathList.size() > this.maximum) {
            ModificationTimeComparator modificationTimeComparator = new ModificationTimeComparator();
            this.pathList.sort(modificationTimeComparator);
            if (modificationTimeComparator.getIoException() != null) {
                throw modificationTimeComparator.getIoException();
            }
            do {
                Files.deleteIfExists(this.pathList.removeLast());
            } while (this.pathList.size() > this.maximum);
        }
    }

    private class ModificationTimeComparator
    implements Comparator<Path> {
        private final HashMap<Path, Long> timeMap = new HashMap();
        private IOException ioException;

        private ModificationTimeComparator() {
        }

        public IOException getIoException() {
            return this.ioException;
        }

        @Override
        public int compare(Path path1, Path path2) {
            return this.getModificationTime(path1).compareTo(this.getModificationTime(path2));
        }

        private Long getModificationTime(Path path) {
            Long time = this.timeMap.get(path);
            if (time == null) {
                try {
                    time = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                    this.timeMap.put(path, time);
                }
                catch (IOException ioException) {
                    this.ioException = ioException;
                    this.timeMap.put(path, 0L);
                }
            }
            return time;
        }
    }
}

