/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.smallmind.nutsnbolts.http.Base64Codec;
import org.smallmind.scribe.pen.AbstractAppender;
import org.smallmind.scribe.pen.DateFormatTimestamp;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.FluentBitConnectionException;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.MessagePackFormatter;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.RecordElement;
import org.smallmind.scribe.pen.Timestamp;
import org.springframework.beans.factory.InitializingBean;

public class FluentBitAppender
extends AbstractAppender
implements InitializingBean {
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
    private MessagePackFormatter formatter;
    private Socket socket;
    private Map<String, String> additionalEventData;
    private Timestamp timestamp = DateFormatTimestamp.getDefaultInstance();
    private RecordElement[] recordElements = RecordElement.values();
    private ArrayNode entriesNode;
    private String newLine = System.getProperty("line.separator");
    private String host;
    private int port;
    private int retryAttempts = 3;
    private int batch = 1;

    public FluentBitAppender(String name) {
        this(name, null);
    }

    public FluentBitAppender(String name, ErrorHandler errorHandler) {
        super(name, errorHandler);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public void setRecordElements(RecordElement[] recordElements) {
        this.recordElements = recordElements;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    public void setAdditionalEventData(Map<String, String> additionalEventData) {
        this.additionalEventData = additionalEventData;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setBatch(int batch) {
        this.batch = batch;
    }

    public void afterPropertiesSet() {
        this.formatter = new MessagePackFormatter(this.timestamp, this.recordElements, this.newLine);
        this.entriesNode = JsonNodeFactory.instance.arrayNode(this.batch);
    }

    @Override
    public synchronized void close() throws LoggerException {
        if (this.finished.compareAndSet(false, true) && this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ioException) {
                throw new LoggerException(ioException);
            }
        }
    }

    @Override
    public synchronized void handleOutput(Record<?> record) throws IOException, LoggerException {
        if (this.finished.get()) {
            throw new LoggerException("%s has been previously closed", this.getClass().getSimpleName());
        }
        ArrayNode entryNode = JsonNodeFactory.instance.arrayNode();
        ObjectNode messageNode = JsonNodeFactory.instance.objectNode();
        ObjectNode recordNode = this.formatter.format(record);
        if (this.additionalEventData != null && !this.additionalEventData.isEmpty()) {
            for (Map.Entry<String, String> additionalDataEntry : this.additionalEventData.entrySet()) {
                recordNode.put(additionalDataEntry.getKey(), additionalDataEntry.getValue());
            }
        }
        messageNode.set("message", (JsonNode)recordNode);
        entryNode.add(record.getMillis() / 1000L);
        entryNode.add((JsonNode)messageNode);
        if (this.entriesNode.add((JsonNode)entryNode).size() >= this.batch) {
            try {
                ArrayNode eventNode = JsonNodeFactory.instance.arrayNode();
                ObjectNode optionNode = JsonNodeFactory.instance.objectNode();
                byte[] chunk = new byte[16];
                int retry = 0;
                ThreadLocalRandom.current().nextBytes(chunk);
                optionNode.put("chunk", Base64Codec.encode((byte[])chunk));
                optionNode.put("size", this.batch);
                eventNode.add(this.getName());
                eventNode.add((JsonNode)this.entriesNode);
                eventNode.add((JsonNode)optionNode);
                do {
                    try {
                        if (this.socket == null) {
                            this.connect();
                        } else if (this.socket.isClosed() || !this.socket.isConnected()) {
                            this.socket.close();
                            this.connect();
                        }
                        this.socket.getOutputStream().write(this.objectMapper.writeValueAsBytes((Object)eventNode));
                    }
                    catch (IOException ioException) {
                        this.socket = null;
                        if (++retry <= this.retryAttempts) continue;
                        throw new FluentBitConnectionException(ioException, "Failed to connect to host(%s:%d)", this.host, this.port);
                    }
                } while (this.socket == null);
            }
            finally {
                this.entriesNode = JsonNodeFactory.instance.arrayNode(this.batch);
            }
        }
    }

    private void connect() throws IOException {
        this.socket = new Socket(this.host, this.port);
        this.socket.setTcpNoDelay(true);
        this.socket.setSoTimeout(1000);
    }
}

