/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.scribe.pen.CleanupRule;

public class LastModifiedCleanupRule
implements CleanupRule<LastModifiedCleanupRule> {
    private final long now = System.currentTimeMillis();
    private Stint stint;
    private long durationAsMilliseconds;

    public LastModifiedCleanupRule() {
    }

    public LastModifiedCleanupRule(Stint stint) {
        this.setStint(stint);
    }

    public Stint getStint() {
        return this.stint;
    }

    public void setStint(Stint stint) {
        this.stint = stint;
        this.durationAsMilliseconds = stint.toMilliseconds();
    }

    @Override
    public LastModifiedCleanupRule copy() {
        return new LastModifiedCleanupRule(this.stint);
    }

    @Override
    public boolean willCleanup(Path possiblePath) throws IOException {
        return this.now - Files.getLastModifiedTime(possiblePath, new LinkOption[0]).toMillis() > this.durationAsMilliseconds;
    }

    @Override
    public void finish() {
    }
}

