/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.Serializable;
import java.util.function.Supplier;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.Enhancer;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.Template;
import org.smallmind.scribe.pen.adapter.LoggerAdapter;
import org.smallmind.scribe.pen.adapter.LoggingBlueprintFactory;

public class Logger {
    private final LoggerAdapter loggerAdapter;

    public Logger(Class loggableClass) {
        this(loggableClass.getCanonicalName());
    }

    public Logger(String name) {
        this.loggerAdapter = LoggingBlueprintFactory.getLoggingBlueprint().getLoggingAdapter(name);
    }

    public String getName() {
        return this.loggerAdapter.getName();
    }

    public Template getTemplate() {
        return LoggerManager.getTemplate(this);
    }

    public void putParameter(String key, Serializable value) {
        this.loggerAdapter.getParameterAdapter().put(key, value);
    }

    public void removeParameter(String key) {
        this.loggerAdapter.getParameterAdapter().remove(key);
    }

    public void clearParameters() {
        this.loggerAdapter.getParameterAdapter().clear();
    }

    public Parameter[] getParameters() {
        return this.loggerAdapter.getParameterAdapter().getParameters();
    }

    public boolean getAutoFillLoggerContext() {
        return this.loggerAdapter.getAutoFillLoggerContext();
    }

    public void setAutoFillLoggerContext(boolean autoFillLoggerContext) {
        this.loggerAdapter.setAutoFillLoggerContext(autoFillLoggerContext);
    }

    public void addFilters(Filter[] filters) {
        Filter[] filterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            Filter filter = filterArray[n2];
            this.addFilter(filter);
            ++n2;
        }
    }

    public void addFilter(Filter filter) {
        this.loggerAdapter.addFilter(filter);
    }

    public void clearFilters() {
        this.loggerAdapter.clearFilters();
    }

    public void addAppenders(Appender[] appenders) {
        Appender[] appenderArray = appenders;
        int n = appenders.length;
        int n2 = 0;
        while (n2 < n) {
            Appender appender = appenderArray[n2];
            this.addAppender(appender);
            ++n2;
        }
    }

    public void addAppender(Appender appender) {
        this.loggerAdapter.addAppender(appender);
    }

    public void clearAppenders() {
        this.loggerAdapter.clearAppenders();
    }

    public void addEnhancer(Enhancer enhancer) {
        this.loggerAdapter.addEnhancer(enhancer);
    }

    public void clearEnhancers() {
        this.loggerAdapter.clearEnhancers();
    }

    public Level getLevel() {
        return this.loggerAdapter.getLevel();
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("Can't set a 'null' default level");
        }
        this.loggerAdapter.setLevel(level);
    }

    public void trace(Throwable throwable) {
        this.log(Level.TRACE, throwable);
    }

    public void trace(String message, Object ... args) {
        this.log(Level.TRACE, message, args);
    }

    public void trace(Throwable throwable, String message, Object ... args) {
        this.log(Level.TRACE, throwable, message, args);
    }

    public void trace(Object object) {
        this.log(Level.TRACE, object);
    }

    public void trace(Supplier<String> supplier) {
        this.log(Level.TRACE, supplier);
    }

    public void trace(Throwable throwable, Object object) {
        this.log(Level.TRACE, throwable, object);
    }

    public void trace(Throwable throwable, Supplier<String> supplier) {
        this.log(Level.TRACE, throwable, supplier);
    }

    public void debug(Throwable throwable) {
        this.log(Level.DEBUG, throwable);
    }

    public void debug(String message, Object ... args) {
        this.log(Level.DEBUG, message, args);
    }

    public void debug(Throwable throwable, String message, Object ... args) {
        this.log(Level.DEBUG, throwable, message, args);
    }

    public void debug(Object object) {
        this.log(Level.DEBUG, object);
    }

    public void debug(Supplier<String> supplier) {
        this.log(Level.DEBUG, supplier);
    }

    public void debug(Throwable throwable, Object object) {
        this.log(Level.DEBUG, throwable, object);
    }

    public void debug(Throwable throwable, Supplier<String> supplier) {
        this.log(Level.DEBUG, throwable, supplier);
    }

    public void info(Throwable throwable) {
        this.log(Level.INFO, throwable);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    public void info(Throwable throwable, String message, Object ... args) {
        this.log(Level.INFO, throwable, message, args);
    }

    public void info(Object object) {
        this.log(Level.INFO, object);
    }

    public void info(Supplier<String> supplier) {
        this.log(Level.INFO, supplier);
    }

    public void info(Throwable throwable, Object object) {
        this.log(Level.INFO, throwable, object);
    }

    public void info(Throwable throwable, Supplier<String> supplier) {
        this.log(Level.INFO, throwable, supplier);
    }

    public void warn(Throwable throwable) {
        this.log(Level.WARN, throwable);
    }

    public void warn(String message, Object ... args) {
        this.log(Level.WARN, message, args);
    }

    public void warn(Throwable throwable, String message, Object ... args) {
        this.log(Level.WARN, throwable, message, args);
    }

    public void warn(Object object) {
        this.log(Level.WARN, object);
    }

    public void warn(Supplier<String> supplier) {
        this.log(Level.WARN, supplier);
    }

    public void warn(Throwable throwable, Object object) {
        this.log(Level.WARN, throwable, object);
    }

    public void warn(Throwable throwable, Supplier<String> supplier) {
        this.log(Level.WARN, throwable, supplier);
    }

    public void error(Throwable throwable) {
        this.log(Level.ERROR, throwable);
    }

    public void error(String message, Object ... args) {
        this.log(Level.ERROR, message, args);
    }

    public void error(Throwable throwable, String message, Object ... args) {
        this.log(Level.ERROR, throwable, message, args);
    }

    public void error(Object object) {
        this.log(Level.ERROR, object);
    }

    public void error(Supplier<String> supplier) {
        this.log(Level.ERROR, supplier);
    }

    public void error(Throwable throwable, Object object) {
        this.log(Level.ERROR, throwable, object);
    }

    public void error(Throwable throwable, Supplier<String> supplier) {
        this.log(Level.ERROR, throwable, supplier);
    }

    public void fatal(Throwable throwable) {
        this.log(Level.FATAL, throwable);
    }

    public void fatal(String message, Object ... args) {
        this.log(Level.FATAL, message, args);
    }

    public void fatal(Throwable throwable, String message, Object ... args) {
        this.log(Level.FATAL, throwable, message, args);
    }

    public void fatal(Object object) {
        this.log(Level.FATAL, object);
    }

    public void fatal(Supplier<String> supplier) {
        this.log(Level.FATAL, supplier);
    }

    public void fatal(Throwable throwable, Object object) {
        this.log(Level.FATAL, throwable, object);
    }

    public void fatal(Throwable throwable, Supplier<String> supplier) {
        this.log(Level.FATAL, throwable, supplier);
    }

    public void log(Level level, Throwable throwable) {
        this.loggerAdapter.logMessage(level == null ? this.getLevel() : level, throwable, null);
    }

    public void log(Level level, String message, Object ... args) {
        this.loggerAdapter.logMessage(level == null ? this.getLevel() : level, null, message, args);
    }

    public void log(Level level, Throwable throwable, String message, Object ... args) {
        this.loggerAdapter.logMessage(level == null ? this.getLevel() : level, throwable, message, args);
    }

    public void log(Level level, Object object) {
        this.loggerAdapter.logMessage(level == null ? this.getLevel() : level, null, object);
    }

    public void log(Level level, Supplier<String> supplier) {
        this.loggerAdapter.logMessage(level == null ? this.getLevel() : level, null, supplier);
    }

    public void log(Level level, Throwable throwable, Object object) {
        this.loggerAdapter.logMessage(level == null ? this.getLevel() : level, throwable, object);
    }

    public void log(Level level, Throwable throwable, Supplier<String> supplier) {
        this.loggerAdapter.logMessage(level == null ? this.getLevel() : level, throwable, supplier);
    }
}

