/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.LoggerContext;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.RecordElement;
import org.smallmind.scribe.pen.Timestamp;

public class MessagePackFormatter {
    private final Timestamp timestamp;
    private final RecordElement[] recordElements;
    private final String newLine;

    public MessagePackFormatter(Timestamp timestamp, RecordElement[] recordElements, String newLine) {
        this.timestamp = timestamp;
        this.recordElements = recordElements;
        this.newLine = newLine;
    }

    public ObjectNode format(Record<?> record) {
        ObjectNode messageNode = JsonNodeFactory.instance.objectNode();
        RecordElement[] recordElementArray = this.recordElements;
        int n = this.recordElements.length;
        int n2 = 0;
        while (n2 < n) {
            RecordElement recordElement = recordElementArray[n2];
            switch (recordElement) {
                case DATE: {
                    messageNode.put("date", this.timestamp.getTimestamp(new Date(record.getMillis())));
                    break;
                }
                case MILLISECONDS: {
                    messageNode.put("milliseconds", record.getMillis());
                    break;
                }
                case LOGGER_NAME: {
                    messageNode.put("logger", record.getLoggerName());
                    break;
                }
                case LEVEL: {
                    messageNode.put("level", record.getLevel().name());
                    break;
                }
                case MESSAGE: {
                    Throwable throwable;
                    String message = record.getMessage();
                    if (message == null && (throwable = record.getThrown()) != null) {
                        message = throwable.getMessage();
                    }
                    messageNode.put("message", message);
                    break;
                }
                case THREAD: {
                    this.appendThreadInfo(messageNode, record.getThreadName(), record.getThreadID());
                    break;
                }
                case LOGGER_CONTEXT: {
                    this.appendLoggerContext(messageNode, record.getLoggerContext());
                    break;
                }
                case PARAMETERS: {
                    this.appendParameters(messageNode, record.getParameters());
                    break;
                }
                case STACK_TRACE: {
                    this.appendStackTrace(messageNode, record.getThrown());
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(recordElement.name(), new Object[0]);
                }
            }
            ++n2;
        }
        return messageNode;
    }

    private void appendThreadInfo(ObjectNode messageNode, String threadName, long threadId) {
        if (threadName != null || threadId > 0L) {
            ObjectNode threadNode = JsonNodeFactory.instance.objectNode();
            if (threadName != null) {
                threadNode.put("name", threadName);
            }
            if (threadId > 0L) {
                threadNode.put("id", threadId);
            }
            messageNode.set("thread", (JsonNode)threadNode);
        }
    }

    private void appendLoggerContext(ObjectNode messageNode, LoggerContext loggerContext) {
        if (loggerContext != null && loggerContext.isFilled()) {
            ObjectNode contextNode = JsonNodeFactory.instance.objectNode();
            contextNode.put("class", loggerContext.getClassName());
            contextNode.put("method", loggerContext.getMethodName());
            contextNode.put("native", loggerContext.isNativeMethod());
            if (!loggerContext.isNativeMethod() && loggerContext.getLineNumber() > 0) {
                contextNode.put("line", loggerContext.getLineNumber());
            }
            contextNode.put("file", loggerContext.getFileName());
            messageNode.set("context", (JsonNode)contextNode);
        }
    }

    private void appendParameters(ObjectNode messageNode, Parameter[] parameters) {
        if (parameters.length > 0) {
            ObjectNode parametersNode = JsonNodeFactory.instance.objectNode();
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                String key = parameter.getKey();
                if (key != null) {
                    if (parameter.getValue() == null) {
                        parametersNode.set(key, (JsonNode)JsonNodeFactory.instance.nullNode());
                    } else {
                        parametersNode.put(key, parameter.getValue().toString());
                    }
                }
                ++n2;
            }
            if (!parametersNode.isEmpty()) {
                messageNode.set("parameters", (JsonNode)parametersNode);
            }
        }
    }

    private void appendStackTrace(ObjectNode messageNode, Throwable throwable) {
        StackTraceElement[] prevStackTrace = null;
        if (throwable != null) {
            StringBuilder traceBuilder = new StringBuilder();
            do {
                if (prevStackTrace == null) {
                    traceBuilder.append("Exception in thread ");
                } else {
                    traceBuilder.append("Caused by: ");
                }
                traceBuilder.append(throwable.getClass().getCanonicalName());
                traceBuilder.append(": ");
                traceBuilder.append(throwable.getMessage());
                traceBuilder.append(this.newLine);
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int repeatedElements;
                    StackTraceElement singleElement = stackTraceElementArray[n2];
                    traceBuilder.append("   ");
                    if (prevStackTrace != null && (repeatedElements = this.findRepeatedStackElements(singleElement, prevStackTrace)) >= 0) {
                        traceBuilder.append("   ... ");
                        traceBuilder.append(repeatedElements);
                        traceBuilder.append(" more");
                        traceBuilder.append(this.newLine);
                        break;
                    }
                    traceBuilder.append("   at ");
                    traceBuilder.append(singleElement.toString());
                    traceBuilder.append(this.newLine);
                    ++n2;
                }
                prevStackTrace = throwable.getStackTrace();
            } while ((throwable = throwable.getCause()) != null);
            messageNode.put("stackTrace", traceBuilder.toString());
        }
    }

    private int findRepeatedStackElements(StackTraceElement singleElement, StackTraceElement[] prevStackTrace) {
        int count = 0;
        while (count < prevStackTrace.length) {
            if (singleElement.equals(prevStackTrace[count])) {
                return prevStackTrace.length - count;
            }
            ++count;
        }
        return -1;
    }
}

