/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smallmind.scribe.pen.ConversionPatternRule;
import org.smallmind.scribe.pen.DateFormatTimestamp;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.PatternRule;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.StaticPatternRule;
import org.smallmind.scribe.pen.Timestamp;

public class PatternFormatter
implements Formatter {
    private static final Pattern CONVERSION_PATTERN = Pattern.compile("%%|(\\{([^{}]+))?%(([+\\-])?(\\d+))?(\\.(\\d+))?(!([+\\-])([^!]*)!)?([dtnlmTCMNLFsp])(([^{%]+)})?");
    private static final StaticPatternRule DOUBLE_PERCENT_RULE = new StaticPatternRule("%");
    private PatternRule[] patternRules;
    private Timestamp timestamp;

    public PatternFormatter() {
        this(DateFormatTimestamp.getDefaultInstance(), "%d %n %+5l [%T] - %m");
    }

    public PatternFormatter(String format) {
        this(DateFormatTimestamp.getDefaultInstance(), format);
    }

    public PatternFormatter(Timestamp timestamp, String format) {
        this.timestamp = timestamp;
        if (format != null) {
            this.setFormat(format);
        }
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public void setFormat(String format) {
        Matcher conversionMatcher = CONVERSION_PATTERN.matcher(format);
        int index = 0;
        LinkedList<PatternRule> ruleList = new LinkedList<PatternRule>();
        while (conversionMatcher.find(index)) {
            if (index < conversionMatcher.start()) {
                ruleList.add(new StaticPatternRule(format.substring(index, conversionMatcher.start())));
            }
            if (conversionMatcher.group().equals("%%")) {
                ruleList.add(DOUBLE_PERCENT_RULE);
            } else {
                ruleList.add(new ConversionPatternRule(conversionMatcher.group(2), conversionMatcher.group(4), conversionMatcher.group(5), conversionMatcher.group(7), conversionMatcher.group(9), conversionMatcher.group(10), conversionMatcher.group(11), conversionMatcher.group(13)));
            }
            index = conversionMatcher.end();
        }
        if (index < format.length()) {
            ruleList.add(new StaticPatternRule(format.substring(index)));
        }
        this.patternRules = new PatternRule[ruleList.size()];
        ruleList.toArray(this.patternRules);
    }

    @Override
    public String format(Record<?> record) {
        StringBuilder formatBuilder = new StringBuilder();
        PatternRule[] patternRuleArray = this.patternRules;
        int n = this.patternRules.length;
        int n2 = 0;
        while (n2 < n) {
            PatternRule patternRule = patternRuleArray[n2];
            String conversion = patternRule.convert(record, this.timestamp);
            if (conversion != null) {
                String header = patternRule.getHeader();
                if (header != null) {
                    formatBuilder.append(header);
                }
                formatBuilder.append(conversion);
                String footer = patternRule.getFooter();
                if (footer != null) {
                    formatBuilder.append(footer);
                }
            }
            ++n2;
        }
        formatBuilder.append(System.getProperty("line.separator"));
        return formatBuilder.toString();
    }
}

