/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.Enhancer;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.LoggerRuntimeException;
import org.smallmind.scribe.pen.Template;

public class PersonalizedTemplate
extends Template {
    private final AtomicReference<String> loggerNameRef = new AtomicReference();

    public PersonalizedTemplate() {
    }

    public PersonalizedTemplate(String loggerName) {
        this.loggerNameRef.set(loggerName);
    }

    public PersonalizedTemplate(Level level, boolean autoFillLoggerContext, String loggerName) throws LoggerException {
        super(level, autoFillLoggerContext);
        this.loggerNameRef.set(loggerName);
    }

    public PersonalizedTemplate(Filter[] filters, Appender[] appenders, Enhancer[] enhancers, Level level, boolean autoFillLoggerContext, String loggerName) throws LoggerException {
        super(filters, appenders, enhancers, level, autoFillLoggerContext);
        this.loggerNameRef.set(loggerName);
    }

    public void setLoggerName(String loggerName) {
        if (!this.loggerNameRef.compareAndSet(null, loggerName)) {
            throw new LoggerRuntimeException("PersonalizedTemplate has been previously initialized with a logger name", new Object[0]);
        }
    }

    @Override
    public int matchLogger(String loggerName) {
        if (this.loggerNameRef.get() == null) {
            throw new LoggerRuntimeException("PersonalizedTemplate was never initialized with a logger name", new Object[0]);
        }
        return this.loggerNameRef.get().equals(loggerName) ? Integer.MAX_VALUE : -1;
    }
}

