/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogMessageIF;
import org.productivity.java.syslog4j.impl.message.structured.StructuredSyslogMessage;
import org.productivity.java.syslog4j.impl.net.udp.UDPNetSyslogConfig;
import org.smallmind.nutsnbolts.http.Base64Codec;
import org.smallmind.nutsnbolts.lang.StackTraceUtility;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.AbstractAppender;
import org.smallmind.scribe.pen.LoggerContext;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.Record;
import org.springframework.beans.factory.InitializingBean;

public class SyslogAppender
extends AbstractAppender
implements InitializingBean {
    private SyslogIF syslog;
    private String syslogHost = "localhost";
    private String facility = "LOCAL7";
    private boolean base64EncodeStackTraces = false;
    private int syslogPort = 514;

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    public int getSyslogPort() {
        return this.syslogPort;
    }

    public void setSyslogPort(int syslogPort) {
        this.syslogPort = syslogPort;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public boolean isBase64EncodeStackTraces() {
        return this.base64EncodeStackTraces;
    }

    public void setBase64EncodeStackTraces(boolean base64EncodeStackTraces) {
        this.base64EncodeStackTraces = base64EncodeStackTraces;
    }

    public void afterPropertiesSet() {
        UDPNetSyslogConfig config = new UDPNetSyslogConfig();
        config.setHost(this.syslogHost);
        config.setPort(this.syslogPort);
        config.setUseStructuredData(true);
        config.setFacility(this.facility);
        this.syslog = Syslog.createInstance((String)"logging", (SyslogConfigIF)config);
    }

    @Override
    public void handleOutput(Record<?> record) throws IOException {
        Parameter[] parameters;
        LoggerContext loggerContext;
        Throwable throwable;
        HashMap idMap = new HashMap();
        HashMap<String, String> logParamMap = new HashMap<String, String>();
        idMap.put("log", logParamMap);
        logParamMap.put("timestamp", String.valueOf(record.getMillis()));
        logParamMap.put("logger", record.getLoggerName());
        String threadName = record.getThreadName();
        long threadId = record.getThreadID();
        if (threadName != null || threadId > 0L) {
            HashMap<String, String> threadParamMap = new HashMap<String, String>();
            idMap.put("thread", threadParamMap);
            if (threadName != null) {
                threadParamMap.put("name", threadName);
            }
            if (threadId > 0L) {
                threadParamMap.put("id", String.valueOf(threadId));
            }
        }
        if ((throwable = record.getThrown()) != null) {
            logParamMap.put("stack-trace", this.base64EncodeStackTraces ? Base64Codec.encode((String)StackTraceUtility.obtainStackTraceAsString((Throwable)throwable)) : StackTraceUtility.obtainStackTraceAsString((Throwable)throwable));
        }
        if ((loggerContext = record.getLoggerContext()) != null && loggerContext.isFilled()) {
            int lineNumber;
            HashMap<String, String> contextParamMap = new HashMap<String, String>();
            idMap.put("context", contextParamMap);
            contextParamMap.put("class", loggerContext.getClassName());
            contextParamMap.put("method", loggerContext.getMethodName());
            contextParamMap.put("native", String.valueOf(loggerContext.isNativeMethod()));
            contextParamMap.put("file", loggerContext.getFileName());
            if (!loggerContext.isNativeMethod() && (lineNumber = loggerContext.getLineNumber()) > 0) {
                contextParamMap.put("line", String.valueOf(lineNumber));
            }
        }
        if ((parameters = record.getParameters()).length > 0) {
            HashMap<String, String> parameterParamMap = new HashMap<String, String>();
            idMap.put("parameters", parameterParamMap);
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                String key = parameter.getKey();
                Serializable value = parameter.getValue();
                parameterParamMap.put(key == null ? "null" : key, value == null ? "null" : value.toString());
                ++n2;
            }
        }
        StructuredSyslogMessage message = new StructuredSyslogMessage(String.valueOf(record.getSequenceNumber()), idMap, record.getMessage());
        switch (record.getLevel()) {
            case FATAL: {
                this.syslog.critical((SyslogMessageIF)message);
                break;
            }
            case ERROR: {
                this.syslog.error((SyslogMessageIF)message);
                break;
            }
            case WARN: {
                this.syslog.warn((SyslogMessageIF)message);
                break;
            }
            case INFO: {
                this.syslog.info((SyslogMessageIF)message);
                break;
            }
            case DEBUG: {
                this.syslog.debug((SyslogMessageIF)message);
                break;
            }
            case TRACE: {
                this.syslog.debug((SyslogMessageIF)message);
                break;
            }
            case OFF: {
                break;
            }
            default: {
                throw new UnknownSwitchCaseException(record.getLevel().name(), new Object[0]);
            }
        }
    }
}

