/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.Serializable;
import java.util.Date;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.DateFormatTimestamp;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LoggerContext;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.RecordElement;
import org.smallmind.scribe.pen.Timestamp;

public class XMLFormatter
implements Formatter {
    private Timestamp timestamp = DateFormatTimestamp.getDefaultInstance();
    private RecordElement[] recordElements = RecordElement.values();
    private String newLine = System.getProperty("line.separator");
    private boolean cdata = false;
    private int indent = 3;

    public XMLFormatter() {
    }

    public XMLFormatter(Timestamp timestamp, String newLine, int indent, boolean cdata, RecordElement ... recordElements) {
        this.timestamp = timestamp;
        this.newLine = newLine;
        this.indent = indent;
        this.cdata = cdata;
        this.recordElements = recordElements;
    }

    private static int findRepeatedStackElements(StackTraceElement singleElement, StackTraceElement[] prevStackTrace) {
        int count = 0;
        while (count < prevStackTrace.length) {
            if (singleElement.equals(prevStackTrace[count])) {
                return prevStackTrace.length - count;
            }
            ++count;
        }
        return -1;
    }

    public XMLFormatter setRecordElements(RecordElement[] recordElements) {
        this.recordElements = recordElements;
        return this;
    }

    public XMLFormatter setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public XMLFormatter setNewLine(String newLine) {
        this.newLine = newLine;
        return this;
    }

    public XMLFormatter setCdata(boolean cdata) {
        this.cdata = cdata;
        return this;
    }

    public XMLFormatter setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    @Override
    public String format(Record<?> record) {
        StringBuilder formatBuilder = new StringBuilder();
        this.appendLine(formatBuilder, "<log-record>", 0);
        RecordElement[] recordElementArray = this.recordElements;
        int n = this.recordElements.length;
        int n2 = 0;
        while (n2 < n) {
            RecordElement recordElement = recordElementArray[n2];
            switch (recordElement) {
                case DATE: {
                    this.appendElement(formatBuilder, "date", this.timestamp.getTimestamp(new Date(record.getMillis())), false, 1);
                    break;
                }
                case MILLISECONDS: {
                    this.appendElement(formatBuilder, "milliseconds", String.valueOf(record.getMillis()), false, 1);
                    break;
                }
                case LOGGER_NAME: {
                    this.appendElement(formatBuilder, "logger", record.getLoggerName(), false, 1);
                    break;
                }
                case LEVEL: {
                    this.appendElement(formatBuilder, "level", record.getLevel().name(), false, 1);
                    break;
                }
                case MESSAGE: {
                    Throwable throwable;
                    String message = record.getMessage();
                    if (message == null && (throwable = record.getThrown()) != null) {
                        message = throwable.getMessage();
                    }
                    this.appendElement(formatBuilder, "message", message, this.cdata, 1);
                    break;
                }
                case THREAD: {
                    this.appendThreadInfo(formatBuilder, record.getThreadName(), record.getThreadID(), 1);
                    break;
                }
                case LOGGER_CONTEXT: {
                    this.appendLoggerContext(formatBuilder, record.getLoggerContext(), 1);
                    break;
                }
                case PARAMETERS: {
                    this.appendParameters(formatBuilder, record.getParameters(), 1);
                    break;
                }
                case STACK_TRACE: {
                    this.appendStackTrace(formatBuilder, record.getThrown(), 1);
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(recordElement.name(), new Object[0]);
                }
            }
            ++n2;
        }
        this.appendFinalLine(formatBuilder, "</log-record>", 0);
        return formatBuilder.toString();
    }

    private void appendThreadInfo(StringBuilder formatBuilder, String threadName, long threadId, int level) {
        if (threadName != null || threadId > 0L) {
            this.appendLine(formatBuilder, "<thread>", level);
            this.appendElement(formatBuilder, "name", threadName, false, level + 1);
            this.appendElement(formatBuilder, "id", threadId > 0L ? String.valueOf(threadId) : null, false, level + 1);
            this.appendLine(formatBuilder, "</thread>", level);
        }
    }

    private void appendLoggerContext(StringBuilder formatBuilder, LoggerContext loggerContext, int level) {
        if (loggerContext != null && loggerContext.isFilled()) {
            this.appendLine(formatBuilder, "<context>", level);
            this.appendElement(formatBuilder, "class", loggerContext.getClassName(), false, level + 1);
            this.appendElement(formatBuilder, "method", loggerContext.getMethodName(), false, level + 1);
            this.appendElement(formatBuilder, "native", String.valueOf(loggerContext.isNativeMethod()), false, level + 1);
            this.appendElement(formatBuilder, "line", !loggerContext.isNativeMethod() && loggerContext.getLineNumber() > 0 ? String.valueOf(loggerContext.getLineNumber()) : null, false, level + 1);
            this.appendElement(formatBuilder, "file", loggerContext.getFileName(), false, level + 1);
            this.appendLine(formatBuilder, "</context>", level);
        }
    }

    private void appendParameters(StringBuilder formatBuilder, Parameter[] parameters, int level) {
        if (parameters.length > 0) {
            this.appendLine(formatBuilder, "<parameters>", level);
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                String key = parameter.getKey();
                Serializable value = parameter.getValue();
                this.appendElement(formatBuilder, key == null ? "null" : key, value == null ? "null" : value.toString(), this.cdata, level + 1);
                ++n2;
            }
            this.appendLine(formatBuilder, "</parameters>", level);
        }
    }

    private void appendStackTrace(StringBuilder formatBuilder, Throwable throwable, int level) {
        StackTraceElement[] prevStackTrace = null;
        if (throwable != null) {
            this.appendLine(formatBuilder, this.cdata ? "<stack-trace><![CDATA[" : "<stack-trace>", level);
            do {
                this.appendIndent(formatBuilder, level + 1);
                if (prevStackTrace == null) {
                    formatBuilder.append("Exception in thread ");
                } else {
                    formatBuilder.append("Caused by: ");
                }
                formatBuilder.append(throwable.getClass().getCanonicalName());
                formatBuilder.append(": ");
                formatBuilder.append(throwable.getMessage());
                formatBuilder.append(this.newLine);
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int repeatedElements;
                    StackTraceElement singleElement = stackTraceElementArray[n2];
                    this.appendIndent(formatBuilder, level + 1);
                    if (prevStackTrace != null && (repeatedElements = XMLFormatter.findRepeatedStackElements(singleElement, prevStackTrace)) >= 0) {
                        formatBuilder.append("   ... ");
                        formatBuilder.append(repeatedElements);
                        formatBuilder.append(" more");
                        formatBuilder.append(this.newLine);
                        break;
                    }
                    formatBuilder.append("   at ");
                    formatBuilder.append(singleElement.toString());
                    formatBuilder.append(this.newLine);
                    ++n2;
                }
                prevStackTrace = throwable.getStackTrace();
            } while ((throwable = throwable.getCause()) != null);
            this.appendLine(formatBuilder, this.cdata ? "]]></stack-trace>" : "</stack-trace>", level);
        }
    }

    private void appendElement(StringBuilder formatBuilder, String tagName, String value, boolean includeCDATA, int level) {
        if (value != null) {
            this.appendIndent(formatBuilder, level);
            formatBuilder.append("<");
            formatBuilder.append(tagName);
            formatBuilder.append(">");
            if (includeCDATA) {
                formatBuilder.append("<![CDATA[");
            }
            formatBuilder.append(value);
            if (includeCDATA) {
                formatBuilder.append("]]>");
            }
            formatBuilder.append("</");
            formatBuilder.append(tagName);
            formatBuilder.append(">");
            formatBuilder.append(this.newLine);
        }
    }

    private void appendLine(StringBuilder formatBuilder, String content, int level) {
        this.appendIndent(formatBuilder, level);
        formatBuilder.append(content);
        formatBuilder.append(this.newLine);
    }

    private void appendFinalLine(StringBuilder formatBuilder, String content, int level) {
        this.appendIndent(formatBuilder, level);
        formatBuilder.append(content);
        formatBuilder.append(System.getProperty("line.separator"));
    }

    private void appendIndent(StringBuilder formatBuilder, int level) {
        formatBuilder.append(" ".repeat(level * this.indent));
    }
}

