/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen.spring.plan;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.Cleanup;
import org.smallmind.scribe.pen.ConsoleAppender;
import org.smallmind.scribe.pen.DateFormatTimestamp;
import org.smallmind.scribe.pen.DefaultErrorHandler;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.FileAppender;
import org.smallmind.scribe.pen.FileSizeQuantifier;
import org.smallmind.scribe.pen.FileSizeRolloverRule;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LastModifiedCleanupRule;
import org.smallmind.scribe.pen.PatternFormatter;
import org.smallmind.scribe.pen.Rollover;
import org.smallmind.scribe.pen.Timestamp;
import org.smallmind.scribe.pen.TimestampQuantifier;
import org.smallmind.scribe.pen.TimestampRolloverRule;
import org.smallmind.scribe.pen.spring.plan.LoggingPlan;

public class FileLoggingPlan
extends LoggingPlan {
    private Path logPath = Paths.get("/var/log", new String[0]);
    private DateFormatTimestamp shortTimestamp = new DateFormatTimestamp(new SimpleDateFormat("yyyy-MM-dd"));
    private DateFormatTimestamp fullTimestamp = new DateFormatTimestamp(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    private TimestampQuantifier rolloverPeriod = TimestampQuantifier.TOP_OF_DAY;
    private long retentionDays = 31L;
    private long rolloverMegabyteLimit = 100L;

    public void setLogPath(Path logPath) {
        this.logPath = logPath;
    }

    public void setShortTimestamp(DateFormatTimestamp shortTimestamp) {
        this.shortTimestamp = shortTimestamp;
    }

    public void setFullTimestamp(DateFormatTimestamp fullTimestamp) {
        this.fullTimestamp = fullTimestamp;
    }

    public void setRolloverPeriod(TimestampQuantifier rolloverPeriod) {
        this.rolloverPeriod = rolloverPeriod;
    }

    public void setRetentionDays(long retentionDays) {
        this.retentionDays = retentionDays;
    }

    public void setRolloverMegabyteLimit(long rolloverMegabyteLimit) {
        this.rolloverMegabyteLimit = rolloverMegabyteLimit;
    }

    @Override
    public Appender getAppender() throws IOException {
        Cleanup cleanup = new Cleanup('.', new LastModifiedCleanupRule(new Stint(this.retentionDays, TimeUnit.DAYS)));
        Rollover rollover = new Rollover((Timestamp)this.shortTimestamp, '.', new TimestampRolloverRule(this.rolloverPeriod), new FileSizeRolloverRule(this.rolloverMegabyteLimit, FileSizeQuantifier.MEGABYTES));
        PatternFormatter patternFormatter = new PatternFormatter(this.fullTimestamp, "%d %n %+5l (%.1C.%M:%L) [%T] - %m%!+\n\t!p%!+\n\t!s");
        ConsoleAppender consoleAppender = new ConsoleAppender(patternFormatter);
        DefaultErrorHandler consoleErrorHandler = new DefaultErrorHandler(consoleAppender);
        return new FileAppender(this.logPath, rollover, cleanup, (Formatter)patternFormatter, (ErrorHandler)consoleErrorHandler);
    }
}

