/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen.spring.plan;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.ConsoleAppender;
import org.smallmind.scribe.pen.DateFormatTimestamp;
import org.smallmind.scribe.pen.DefaultErrorHandler;
import org.smallmind.scribe.pen.FluentBitAppender;
import org.smallmind.scribe.pen.PatternFormatter;
import org.smallmind.scribe.pen.spring.plan.LoggingPlan;

public class FluentBitLoggingPlan
extends LoggingPlan {
    private DateFormatTimestamp fullTimestamp = new DateFormatTimestamp(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
    private Map<String, String> additionalEventData;
    private String name;
    private String host;
    private int port;

    public void setFullTimestamp(DateFormatTimestamp fullTimestamp) {
        this.fullTimestamp = fullTimestamp;
    }

    public void setAdditionalEventData(Map<String, String> additionalEventData) {
        this.additionalEventData = additionalEventData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public Appender getAppender() {
        FluentBitAppender fluentBitAppender = new FluentBitAppender(this.name, new DefaultErrorHandler(new ConsoleAppender(new PatternFormatter(this.fullTimestamp, "%d %n %+5l (%.1C.%M:%L) [%T] - %m%!+\n\t!p%!+\n\t!s"))));
        fluentBitAppender.setHost(this.host);
        fluentBitAppender.setPort(this.port);
        fluentBitAppender.setAdditionalEventData(this.additionalEventData);
        fluentBitAppender.afterPropertiesSet();
        return fluentBitAppender;
    }
}

