/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen.spring.plan;

import java.io.IOException;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.AsynchronousAppender;
import org.smallmind.scribe.pen.ClassNameTemplate;
import org.smallmind.scribe.pen.DefaultTemplate;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.spring.plan.Log;
import org.springframework.beans.factory.InitializingBean;

public abstract class LoggingPlan
implements InitializingBean {
    private Log[] logs;
    private Level defaultLogLevel = Level.INFO;
    private int logRecordBufferSize = 400;

    public abstract Appender getAppender() throws IOException;

    public void setDefaultLogLevel(Level defaultLogLevel) {
        this.defaultLogLevel = defaultLogLevel;
    }

    public void setLogRecordBufferSize(int logRecordBufferSize) {
        this.logRecordBufferSize = logRecordBufferSize;
    }

    public void setLogs(Log[] logs) {
        this.logs = logs;
    }

    public void afterPropertiesSet() throws Exception {
        AsynchronousAppender asynchronousAppender = new AsynchronousAppender(this.getAppender(), this.logRecordBufferSize);
        new DefaultTemplate(this.defaultLogLevel, true, asynchronousAppender).register();
        if (this.logs != null && this.logs.length > 0) {
            Log[] logArray = this.logs;
            int n = this.logs.length;
            int n2 = 0;
            while (n2 < n) {
                Log log = logArray[n2];
                new ClassNameTemplate(log.getLevel(), true, log.getPattern(), asynchronousAppender).register();
                ++n2;
            }
        }
    }
}

