/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.slf4j;

import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.spi.LocationAwareLogger;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.Logger;

public class ScribeLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger {
    private Logger logger;

    public ScribeLoggerAdapter(Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.getLevel().noGreater(Level.TRACE);
    }

    private String translateFormat(String format) {
        StringBuilder formatBuilder = new StringBuilder();
        TranslatorState state = TranslatorState.CHAR;
        block5: for (int index = 0; index < format.length(); ++index) {
            char currentChar = format.charAt(index);
            switch (state) {
                case CHAR: {
                    if (currentChar == '\\') {
                        state = TranslatorState.ESCAPE;
                        continue block5;
                    }
                    if (currentChar == '{') {
                        state = TranslatorState.VAR;
                        continue block5;
                    }
                    formatBuilder.append(currentChar);
                    continue block5;
                }
                case ESCAPE: {
                    formatBuilder.append(currentChar);
                    state = TranslatorState.CHAR;
                    continue block5;
                }
                case VAR: {
                    if (currentChar == '{') {
                        formatBuilder.append('{');
                        continue block5;
                    }
                    if (currentChar == '}') {
                        formatBuilder.append("%s");
                    } else {
                        formatBuilder.append('{').append(currentChar);
                    }
                    state = TranslatorState.CHAR;
                    continue block5;
                }
                default: {
                    throw new UnknownSwitchCaseException(state.name(), new Object[0]);
                }
            }
        }
        return formatBuilder.toString();
    }

    public void trace(String msg) {
        this.logger.trace((Object)msg);
    }

    public void trace(String format, Object arg1) {
        this.logger.trace(this.translateFormat(format), new Object[]{arg1});
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logger.trace(this.translateFormat(format), new Object[]{arg1, arg2});
    }

    public void trace(String format, Object[] args) {
        this.logger.trace(this.translateFormat(format), args);
    }

    public void trace(String msg, Throwable throwable) {
        this.logger.trace(throwable, (Object)msg);
    }

    public boolean isDebugEnabled() {
        return this.logger.getLevel().noGreater(Level.DEBUG);
    }

    public void debug(String msg) {
        this.logger.debug((Object)msg);
    }

    public void debug(String format, Object arg1) {
        this.logger.debug(this.translateFormat(format), new Object[]{arg1});
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug(this.translateFormat(format), new Object[]{arg1, arg2});
    }

    public void debug(String format, Object[] args) {
        this.logger.debug(this.translateFormat(format), args);
    }

    public void debug(String msg, Throwable throwable) {
        this.logger.debug(throwable, (Object)msg);
    }

    public void info(String msg) {
        this.logger.info((Object)msg);
    }

    public void info(String format, Object arg1) {
        this.logger.info(this.translateFormat(format), new Object[]{arg1});
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logger.info(this.translateFormat(format), new Object[]{arg1, arg2});
    }

    public void info(String format, Object[] args) {
        this.logger.info(this.translateFormat(format), args);
    }

    public void info(String msg, Throwable throwable) {
        this.logger.info(throwable, (Object)msg);
    }

    public boolean isWarnEnabled() {
        return this.logger.getLevel().noGreater(Level.WARN);
    }

    public void warn(String msg) {
        this.logger.warn((Object)msg);
    }

    public void warn(String format, Object arg1) {
        this.logger.warn(this.translateFormat(format), new Object[]{arg1});
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn(this.translateFormat(format), new Object[]{arg1, arg2});
    }

    public void warn(String format, Object[] args) {
        this.logger.warn(this.translateFormat(format), args);
    }

    public void warn(String msg, Throwable throwable) {
        this.logger.warn(throwable, (Object)msg);
    }

    public boolean isErrorEnabled() {
        return this.logger.getLevel().noGreater(Level.ERROR);
    }

    public void error(String msg) {
        this.logger.error((Object)msg);
    }

    public void error(String format, Object arg1) {
        this.logger.error(this.translateFormat(format), new Object[]{arg1});
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logger.error(this.translateFormat(format), new Object[]{arg1, arg2});
    }

    public void error(String format, Object[] args) {
        this.logger.error(this.translateFormat(format), args);
    }

    public void error(String msg, Throwable throwable) {
        this.logger.error(throwable, (Object)msg);
    }

    public boolean isInfoEnabled() {
        return this.logger.getLevel().noGreater(Level.INFO);
    }

    public void log(Marker marker, String fqcn, int level, String msg, Throwable throwable) {
        this.log(marker, fqcn, level, msg, null, throwable);
    }

    public void log(Marker marker, String fqcn, int level, String msg, Object[] objects, Throwable throwable) {
        Level scribeLevel;
        switch (level) {
            case 0: {
                scribeLevel = Level.TRACE;
                break;
            }
            case 10: {
                scribeLevel = Level.DEBUG;
                break;
            }
            case 20: {
                scribeLevel = Level.INFO;
                break;
            }
            case 30: {
                scribeLevel = Level.WARN;
                break;
            }
            case 40: {
                scribeLevel = Level.ERROR;
                break;
            }
            default: {
                throw new UnknownSwitchCaseException(String.valueOf(level), new Object[0]);
            }
        }
        this.logger.log(scribeLevel, throwable, msg, objects);
    }

    private static enum TranslatorState {
        CHAR,
        ESCAPE,
        VAR;

    }
}

