/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.multicast;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.smallmind.cloud.multicast.PacketBroadcaster;
import org.smallmind.cloud.multicast.event.EventMessage;
import org.smallmind.cloud.multicast.event.MessageStatus;

public class DatagramBroadcastAgent
implements Runnable {
    private CountDownLatch exitLatch;
    private PacketBroadcaster packetBroadcaster;
    private MulticastSocket multicastSocket;
    private DatagramSocket datagramSocket;
    private InetAddress multicastInetAddress;
    private boolean finished = false;
    private int multicastPort;
    private int messageBufferSize;

    public DatagramBroadcastAgent(PacketBroadcaster packetBroadcaster, DatagramSocket datagramSocket, MulticastSocket multicastSocket, InetAddress multicastInetAddress, int multicastPort, int messageSegmentSize) {
        this.packetBroadcaster = packetBroadcaster;
        this.datagramSocket = datagramSocket;
        this.multicastSocket = multicastSocket;
        this.multicastInetAddress = multicastInetAddress;
        this.multicastPort = multicastPort;
        this.messageBufferSize = messageSegmentSize + EventMessage.MESSAGE_HEADER_SIZE;
        this.exitLatch = new CountDownLatch(1);
    }

    public synchronized void finish() throws InterruptedException {
        this.finished = true;
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] messageBuffer = new byte[this.messageBufferSize];
        ByteBuffer translationBuffer = ByteBuffer.wrap(messageBuffer);
        DatagramPacket messagePacket = new DatagramPacket(messageBuffer, messageBuffer.length);
        try {
            while (!this.finished) {
                try {
                    boolean packetReceived;
                    try {
                        this.datagramSocket.receive(messagePacket);
                        packetReceived = true;
                    }
                    catch (SocketTimeoutException s) {
                        packetReceived = false;
                    }
                    if (!packetReceived) continue;
                    translationBuffer.putInt(0, MessageStatus.BROADCAST.ordinal());
                    messagePacket.setPort(this.multicastPort);
                    messagePacket.setAddress(this.multicastInetAddress);
                    this.multicastSocket.send(messagePacket);
                }
                catch (Exception e) {
                    this.packetBroadcaster.logError(e);
                }
            }
            return;
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

