/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.cloud.multicast.wrapper;

import org.smallmind.cloud.multicast.PacketBroadcaster;
import org.smallmind.nutsnbolts.command.CommandException;
import org.smallmind.nutsnbolts.command.CommandLineParser;
import org.smallmind.nutsnbolts.command.CommandSet;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.LoggerManager;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class PacketBroadcasterWrapperListener
implements WrapperListener {
    private static final String[] REQUIRED_ARGUMENTS = new String[]{"multicastip", "multicastport", "broadcasthosts", "broadcastport", "messagesize"};
    private static final int NO_ERROR_CODE = 0;
    private static final int COMMAND_ERROR_CODE = 1;
    private static final int STACK_TRACE_ERROR_CODE = 2;
    private PacketBroadcaster packetBroadcaster;

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }

    public Integer start(String[] args) {
        CommandSet commandSet;
        try {
            commandSet = CommandLineParser.parseCommands((String[])args);
        }
        catch (CommandException commandException) {
            commandException.printStackTrace();
            return 1;
        }
        if (!commandSet.containsAllCommands(REQUIRED_ARGUMENTS)) {
            System.out.println("PacketBroadcasterWrapperListener [multicastip] [multicastport] {broadcasthosts} [broadcastport] [messagesize]");
            return 1;
        }
        String multicastIP = commandSet.getArgument("multicastip");
        int multicastPort = Integer.parseInt(commandSet.getArgument("multicastport"));
        String[] broadcastHosts = commandSet.getArguments("broadcasthost");
        int broadcastPort = Integer.parseInt(commandSet.getArgument("multicastport"));
        int messagesize = Integer.parseInt(commandSet.getArgument("messagesize"));
        try {
            Logger logger = LoggerManager.getLogger(PacketBroadcaster.class);
            this.packetBroadcaster = new PacketBroadcaster(logger, multicastIP, multicastPort, broadcastHosts, broadcastPort, messagesize);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return null;
    }

    public int stop(int event) {
        try {
            this.packetBroadcaster.finish();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new PacketBroadcasterWrapperListener(), (String[])args);
    }
}

