/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.TimeUnit;
import org.smallmind.instrument.Chronometer;
import org.smallmind.instrument.ChronometerImpl;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.Histogram;
import org.smallmind.instrument.HistogramImpl;
import org.smallmind.instrument.Meter;
import org.smallmind.instrument.MeterImpl;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricType;
import org.smallmind.instrument.Samples;
import org.smallmind.instrument.Speedometer;
import org.smallmind.instrument.SpeedometerImpl;
import org.smallmind.instrument.Tally;
import org.smallmind.instrument.TallyImpl;

public class Metrics {
    public static TallyBuilder buildTally(int initialCount) {
        return new TallyBuilder(initialCount);
    }

    public static MeterBuilder buildMeter(long tickInterval, TimeUnit tickTimeUnit) {
        return new MeterBuilder(tickInterval, tickTimeUnit, Clocks.EPOCH);
    }

    public static MeterBuilder buildMeter(long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
        return new MeterBuilder(tickInterval, tickTimeUnit, clocks);
    }

    public static HistogramBuilder buildHistogram(Samples samples) {
        return new HistogramBuilder(samples);
    }

    public static SpeedometerBuilder buildSpeedometer(long tickInterval, TimeUnit tickTimeUnit) {
        return new SpeedometerBuilder(tickInterval, tickTimeUnit, Clocks.EPOCH);
    }

    public static SpeedometerBuilder buildSpeedometer(long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
        return new SpeedometerBuilder(tickInterval, tickTimeUnit, clocks);
    }

    public static ChronometerBuilder buildChronometer(TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit) {
        return new ChronometerBuilder(Samples.BIASED, durationUnit, tickInterval, tickTimeUnit, Clocks.EPOCH);
    }

    public static ChronometerBuilder buildChronometer(Samples samples, TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit) {
        return new ChronometerBuilder(samples, durationUnit, tickInterval, tickTimeUnit, Clocks.EPOCH);
    }

    public static ChronometerBuilder buildChronometer(TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
        return new ChronometerBuilder(Samples.BIASED, durationUnit, tickInterval, tickTimeUnit, clocks);
    }

    public static ChronometerBuilder buildChronometer(Samples samples, TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
        return new ChronometerBuilder(samples, durationUnit, tickInterval, tickTimeUnit, clocks);
    }

    public static class ChronometerBuilder
    implements MetricBuilder<Chronometer> {
        private Samples samples;
        private Clocks clocks;
        private TimeUnit durationUnit;
        private TimeUnit tickTimeUnit;
        private long tickInterval;

        private ChronometerBuilder(Samples samples, TimeUnit durationUnit, long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
            this.samples = samples;
            this.durationUnit = durationUnit;
            this.tickInterval = tickInterval;
            this.tickTimeUnit = tickTimeUnit;
            this.clocks = clocks;
        }

        @Override
        public Class<Chronometer> getMetricClass() {
            return Chronometer.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.CHRONOMETER;
        }

        @Override
        public Chronometer construct() {
            return new ChronometerImpl(this.samples, this.durationUnit, this.tickInterval, this.tickTimeUnit, this.clocks.getClock());
        }
    }

    public static class HistogramBuilder
    implements MetricBuilder<Histogram> {
        private Samples samples;

        private HistogramBuilder(Samples samples) {
            this.samples = samples;
        }

        @Override
        public Class<Histogram> getMetricClass() {
            return Histogram.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.HISTOGRAM;
        }

        @Override
        public Histogram construct() {
            return new HistogramImpl(this.samples);
        }
    }

    public static class MeterBuilder
    implements MetricBuilder<Meter> {
        private Clocks clocks;
        private TimeUnit tickTimeUnit;
        private long tickInterval;

        private MeterBuilder(long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
            this.tickInterval = tickInterval;
            this.tickTimeUnit = tickTimeUnit;
            this.clocks = clocks;
        }

        @Override
        public Class<Meter> getMetricClass() {
            return Meter.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.METER;
        }

        @Override
        public Meter construct() {
            return new MeterImpl(this.tickInterval, this.tickTimeUnit, this.clocks.getClock());
        }
    }

    public static interface MetricBuilder<M extends Metric<M>> {
        public Class<M> getMetricClass();

        public MetricType getType();

        public M construct();
    }

    public static class SpeedometerBuilder
    implements MetricBuilder<Speedometer> {
        private Clocks clocks;
        private TimeUnit tickTimeUnit;
        private long tickInterval;

        private SpeedometerBuilder(long tickInterval, TimeUnit tickTimeUnit, Clocks clocks) {
            this.tickInterval = tickInterval;
            this.tickTimeUnit = tickTimeUnit;
            this.clocks = clocks;
        }

        @Override
        public Class<Speedometer> getMetricClass() {
            return Speedometer.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.SPEEDOMETER;
        }

        @Override
        public Speedometer construct() {
            return new SpeedometerImpl(this.tickInterval, this.tickTimeUnit, this.clocks.getClock());
        }
    }

    public static class TallyBuilder
    implements MetricBuilder<Tally> {
        private int initialCount;

        private TallyBuilder(int initialCount) {
            this.initialCount = initialCount;
        }

        @Override
        public Class<Tally> getMetricClass() {
            return Tally.class;
        }

        @Override
        public MetricType getType() {
            return MetricType.TALLY;
        }

        @Override
        public Tally construct() {
            return new TallyImpl(this.initialCount);
        }
    }
}

