/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.smallmind.nutsnbolts.lang.TypeMismatchException;
import org.smallmind.nutsnbolts.reflection.FieldUtility;
import org.smallmind.nutsnbolts.reflection.Overlay;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.PersistenceException;

public abstract class AbstractDurable<I extends Serializable & Comparable<I>, D extends AbstractDurable<I, D>>
implements Overlay<D>,
Durable<I> {
    private static final ThreadLocal<Set<Durable>> IN_USE_SET_LOCAL = ThreadLocal.withInitial(HashSet::new);

    @Override
    public int compareTo(Durable<I> durable) {
        if (!this.getClass().isAssignableFrom(durable.getClass())) {
            throw new TypeMismatchException("Comparison must be made with a type which extends %s", new Object[]{this.getClass().getSimpleName()});
        }
        if (this.getId() == null) {
            if (durable.getId() == null) {
                return 0;
            }
            return -1;
        }
        if (durable.getId() == null) {
            return 1;
        }
        return ((Comparable)durable.getId()).compareTo(this.getId());
    }

    public synchronized int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        int h = this.getId().hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public synchronized boolean equals(Object obj) {
        if (obj instanceof Durable) {
            if (((Durable)obj).getId() == null || this.getId() == null) {
                return super.equals(obj);
            }
            return ((Durable)obj).getId().equals(this.getId());
        }
        return false;
    }

    public boolean mirrors(Durable durable) {
        return this.mirrors(durable, FieldUtility.getField(this.getClass(), (String)"id"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mirrors(Durable durable, Field ... exclusions) {
        if (!this.getClass().isAssignableFrom(durable.getClass())) return false;
        try {
            Field[] fieldArray = FieldUtility.getFields(this.getClass());
            int n = fieldArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Field field = fieldArray[n2];
                boolean excluded = false;
                if (exclusions != null && exclusions.length > 0) {
                    Field[] fieldArray2 = exclusions;
                    int n3 = exclusions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Field exclusion = fieldArray2[n4];
                        if (!exclusion.getDeclaringClass().isAssignableFrom(this.getClass())) {
                            throw new PersistenceException("The type(%s) does not contain the excluded field(%s)", this.getClass().getName(), exclusion.getName());
                        }
                        if (exclusion.equals(field)) {
                            excluded = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (!excluded) {
                    Object myValue = field.get(this);
                    Object theirValue = field.get(durable);
                    if (myValue == null ? theirValue != null : !myValue.equals(theirValue)) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public String toString() {
        StringBuilder displayBuilder = new StringBuilder();
        if (IN_USE_SET_LOCAL.get().contains(this)) {
            displayBuilder.append(this.getClass().getSimpleName()).append("[id=").append(this.getId()).append(",...]");
        } else {
            try {
                IN_USE_SET_LOCAL.get().add(this);
                boolean first = false;
                displayBuilder.append(this.getClass().getSimpleName()).append('[');
                try {
                    Field[] fieldArray = FieldUtility.getFields(this.getClass());
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        if (first) {
                            displayBuilder.append(',');
                        }
                        displayBuilder.append(field.getName()).append('=').append(field.get(this));
                        first = true;
                        ++n2;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                displayBuilder.append(']');
            }
            finally {
                IN_USE_SET_LOCAL.get().remove(this);
            }
        }
        return displayBuilder.toString();
    }
}

