/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.nutsnbolts.reflection.type.GenericUtility;
import org.smallmind.nutsnbolts.reflection.type.TypeInference;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.Identifier;
import org.smallmind.persistence.ManagedDao;
import org.smallmind.persistence.orm.ORMInitializationException;

public abstract class AbstractManagedDao<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements ManagedDao<I, D> {
    private final TypeInference idTypeInference = new TypeInference();
    private final TypeInference durableTypeInference = new TypeInference();
    private final AtomicReference<Method> fromStringMethodRef = new AtomicReference();
    private final String metricSource;

    public AbstractManagedDao(String metricSource) {
        this.metricSource = metricSource;
        List typeArguments = GenericUtility.getTypeArguments(AbstractManagedDao.class, this.getClass());
        if (typeArguments.size() == 2) {
            if (typeArguments.get(0) != null) {
                this.idTypeInference.addPossibility((Class)typeArguments.get(0));
            }
            if (typeArguments.get(1) != null) {
                this.durableTypeInference.addPossibility((Class)typeArguments.get(1));
            }
        }
    }

    @Override
    public String getMetricSource() {
        return this.metricSource;
    }

    @Override
    public Class<D> getManagedClass() {
        return this.durableTypeInference.getInference();
    }

    @Override
    public Class<I> getIdClass() {
        return this.idTypeInference.getInference();
    }

    @Override
    public I getId(D durable) {
        return durable.getId();
    }

    @Override
    public I getIdFromString(String value) {
        Class<I> idClass = this.getIdClass();
        if (String.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(value));
        }
        if (idClass.isEnum()) {
            return (I)Enum.valueOf(idClass.asSubclass(Enum.class), value);
        }
        if (Long.TYPE.equals(idClass) || Long.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(Long.parseLong(value)));
        }
        if (Boolean.TYPE.equals(idClass) || Boolean.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(Boolean.parseBoolean(value)));
        }
        if (Integer.TYPE.equals(idClass) || Integer.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(Integer.parseInt(value)));
        }
        if (Double.TYPE.equals(idClass) || Double.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(Double.parseDouble(value)));
        }
        if (Float.TYPE.equals(idClass) || Float.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(Float.valueOf(Float.parseFloat(value))));
        }
        if (Character.TYPE.equals(idClass) || Character.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(Character.valueOf(value.charAt(0))));
        }
        if (Short.TYPE.equals(idClass) || Short.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(Short.parseShort(value)));
        }
        if (Byte.TYPE.equals(idClass) || Byte.class.equals(idClass)) {
            return (I)((Serializable)idClass.cast(Byte.parseByte(value)));
        }
        if (Identifier.class.isAssignableFrom(idClass)) {
            try {
                Method fromStringMethod = this.fromStringMethodRef.get();
                if (fromStringMethod == null) {
                    fromStringMethod = idClass.getMethod("fromString", String.class);
                    if (!Modifier.isStatic(fromStringMethod.getModifiers())) {
                        throw new ORMInitializationException("The fromString() method in the identifier class(%s) needs to be declared static", idClass.getName());
                    }
                    this.fromStringMethodRef.compareAndSet(null, fromStringMethod);
                }
                return (I)((Serializable)idClass.cast(fromStringMethod.invoke(null, value)));
            }
            catch (Exception exception) {
                throw new ORMInitializationException(exception);
            }
        }
        throw new ORMInitializationException("Id class is neither a String, an Enum, a primitive type, nor a primitive wrapper, and does not implement Identifier, so you need to override getIdFromString(String value)", new Object[0]);
    }
}

