/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.persistence;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.nutsnbolts.reflection.FieldUtility;
import org.smallmind.nutsnbolts.reflection.type.TypeUtility;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.NaturalKeys;
import org.smallmind.persistence.PersistenceException;

public class NaturalKey<D extends Durable<? extends Comparable>> {
    private static ConcurrentHashMap<Class<? extends Durable>, Field[]> NATURAL_KEY_MAP = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<? extends Durable>, Field[]> NON_KEY_MAP = new ConcurrentHashMap();
    private Class<? extends Durable> durableClass;
    private Object[] naturalKeyFieldValues;

    public NaturalKey(D durable) {
        int index = 0;
        this.durableClass = durable.getClass();
        Field[] naturalKeyFields = NaturalKey.getNaturalKeyFields(this.durableClass);
        this.naturalKeyFieldValues = new Object[naturalKeyFields.length];
        try {
            Field[] fieldArray = naturalKeyFields;
            int n = naturalKeyFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field naturalKeyField = fieldArray[n2];
                this.naturalKeyFieldValues[index++] = naturalKeyField.get(durable);
                ++n2;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public NaturalKey(Class<D> durableClass, Object ... naturalKeyFieldValues) {
        this.durableClass = durableClass;
        this.naturalKeyFieldValues = naturalKeyFieldValues;
        int index = 0;
        Field[] fieldArray = NaturalKey.getNaturalKeyFields(durableClass);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field naturalKeyField = fieldArray[n2];
            if (!TypeUtility.isEssentiallyTheSameAs(naturalKeyField.getType(), naturalKeyFieldValues[index++].getClass())) {
                throw new PersistenceException("Field values must match both order and type of the durables' natural keys(%s)", Arrays.toString(NaturalKey.getNaturalKeyFields(durableClass)));
            }
            ++n2;
        }
    }

    public static Field[] getNonKeyFields(Class<? extends Durable> durableClass) {
        Field[] nonKeyFields = NON_KEY_MAP.get(durableClass);
        if (nonKeyFields == null) {
            Field[] naturalKeyFields = NaturalKey.getNaturalKeyFields(durableClass);
            Field[] durableFields = FieldUtility.getFields(durableClass);
            nonKeyFields = new Field[durableFields.length - naturalKeyFields.length];
            if (nonKeyFields.length > 0) {
                int index = 0;
                Field[] fieldArray = durableFields;
                int n = durableFields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field durableField = fieldArray[n2];
                    boolean matched = false;
                    Field[] fieldArray2 = naturalKeyFields;
                    int n3 = naturalKeyFields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Field naturalKeyField = fieldArray2[n4];
                        if (durableField.equals(naturalKeyField)) {
                            matched = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!matched) {
                        nonKeyFields[index++] = durableField;
                    }
                    ++n2;
                }
            }
            NON_KEY_MAP.put(durableClass, nonKeyFields);
        }
        return nonKeyFields;
    }

    public static Field[] getNaturalKeyFields(Class<? extends Durable> durableClass) {
        Field[] naturalKeyFields = NATURAL_KEY_MAP.get(durableClass);
        if (naturalKeyFields == null) {
            int index = 0;
            NaturalKeys naturalKeys = durableClass.getAnnotation(NaturalKeys.class);
            if (naturalKeys == null) {
                throw new PersistenceException("Missing required annotation(%s)", NaturalKeys.class.getSimpleName());
            }
            naturalKeyFields = new Field[naturalKeys.value().length];
            String[] stringArray = naturalKeys.value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                try {
                    Class<? extends Durable> currentClass = durableClass;
                    Field currentField = null;
                    do {
                        try {
                            currentField = currentClass.getDeclaredField(fieldName);
                            currentField.setAccessible(true);
                            naturalKeyFields[index++] = currentField;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {}
                    } while (currentField != null && (currentClass = currentClass.getSuperclass()) != null);
                    if (currentField == null) {
                        throw new NoSuchFieldException(fieldName);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new PersistenceException(noSuchFieldException);
                }
                NATURAL_KEY_MAP.put(durableClass, naturalKeyFields);
                ++n2;
            }
        }
        return naturalKeyFields;
    }

    public Class<? extends Durable> getDurableClass() {
        return this.durableClass;
    }

    public Object[] getNaturalKeyFieldValues() {
        return this.naturalKeyFieldValues;
    }

    public int hashCode() {
        int hashCode = 0;
        Object[] objectArray = this.naturalKeyFieldValues;
        int n = this.naturalKeyFieldValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            hashCode ^= obj.hashCode();
            ++n2;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof NaturalKey && ((NaturalKey)obj).getDurableClass().equals(this.durableClass) && Arrays.equals(((NaturalKey)obj).getNaturalKeyFieldValues(), this.naturalKeyFieldValues);
    }
}

